
;--- base definitions for COM
;--- usually included by ole2.inc

	include rpc.inc
	include rpcndr.inc

ifndef _OBJBASE_H_
_OBJBASE_H_ equ <>

COINIT_APARTMENTTHREADED	equ 02h
COINIT_MULTITHREADED		equ 00h
COINIT_DISABLE_OLE1DDE		equ 04h
COINIT_SPEED_OVER_MEMORY	equ 08h

ifndef GUID
GUID	STRUCT
    Data1 	dd ?
    Data2 	dw ?
    Data3 	dw ?
    Data4 	db 8 dup(?)
GUID ENDS
endif

DEFINE_GUID macro name,l,w1,w2,b1,b2,b3,b4,b5,b6,b7,b8
;	exitm <name GUID { l , w1 , w2 , { b1 , b2 , b3 , b4 , b5 , b6 , b7 , b8 } } >
	exitm <externdef name:GUID>
	endm

externdef GUID_NULL:GUID

;IID_NULL    textequ <GUID_NULL>
;REFGUID     typedef ptr GUID
;REFIID      typedef ptr IID

ifndef HRESULT
HRESULT			typedef DWORD
endif

ifndef FACILITY_CONTROL
FACILITY_CONTROL equ 0ah
endif

;;-------------------------------------------------------------------
;;--- macros inside:
;;--- SUCCEEDED()			: query successful result of a COM call
;;--- FAILED()				: query unsuccessful result of a COM call
;;--- MAKE_HRESULT()		: assembles a HRESULT
;;--- BEGIN_INTERFACE		: starts definition of a vtable interface
;;--- END_INTERFACE			: ends definition of a vtable interface
;;--- STDMETHOD				: defines an entry in a vtable interface
;;-------------------------------------------------------------------

SUCCEEDED macro x
ifb <x>
	exitm <!SIGN?>
else
if (OPATTR(x)) and 10h
 	test x,x
	exitm <!SIGN?>
else
 	exitm <x !>= 0>
endif
endif
	endm

FAILED macro x
ifb <x>
	exitm <SIGN?>
else
if (OPATTR(x)) and 10h
 	test x,x
	exitm <SIGN?>
else
 	exitm <x !< 0>
endif
endif
	endm

MAKE_HRESULT	macro sev,fac,code
	exitm <sev * 80000000h + fac * 10000h + code>
	endm

;------------------------------------------------------
; BEGIN_INTERFACE starts an interface definition
; Used in COMView generated includes. sets equate ??Interface. 
;------------------------------------------------------
; defines textequates ??Interface, ??Function, so dont use these names
;------------------------------------------------------

BEGIN_INTERFACE macro name, inheritedfrom
ifnb <name>
??Interface equ <name>
&name&Vtbl	struct
ifnb <inheritedfrom>
	inheritedfrom&Vtbl <>
endif
else
??Interface equ <>
endif
		endm

;--- DECLARE_INTERFACE_ is roughly the same as BEGIN_INTERFACE
;--- but is a macro function and ignores "inheritedfrom" parameter

DECLARE_INTERFACE_ macro name, inheritedfrom
??Interface equ <name>
&name&Vtbl	struct
		exitm <>
		endm

DECLARE_INTERFACE macro name
		DECLARE_INTERFACE_ name
		endm

;------------------------------------------------------
; END_INTERFACE finishes current interface definition
; Used in includes. clears equate ??Interface
;------------------------------------------------------

END_INTERFACE macro
ifnb ??Interface
%??Interface&Vtbl	ends
%p&??Interface&Vtbl	typedef ptr ??Interface&Vtbl

??Interface	struct
%lpVtbl p&??Interface&Vtbl ?
??Interface	ends
endif
??Interface equ <>
		endm

;--- DECLARE_INTERFACE__END is the same as END_INTERFACE

DECLARE_INTERFACE__END macro
%??Interface&Vtbl	ends
%p&??Interface&Vtbl	typedef ptr ??Interface&Vtbl

??Interface	struct
%lpVtbl p&??Interface&Vtbl ?
??Interface	ends
??Interface equ <>
		endm

DECLARE_INTERFACE_END macro
	DECLARE_INTERFACE__END
		endm


;------------------------------------------------------
; STDMETHOD macro defines an entry in a vtable interface
; Used in includes generated by COMView. 
;------------------------------------------------------

STDMETHOD	macro name:req,arguments:VARARG

ifnb <arguments>
%proto&??Interface&_&name& typedef proto WINSTDCALLCONV :ptr,&arguments
else
%proto&??Interface&_&name& typedef proto WINSTDCALLCONV :ptr
endif

%p&??Interface&_&name& typedef ptr proto&??Interface&_&name

;;??Function	catstr <name>,<	p>,??Interface,<_>,<name>,< ?>
;;??Function
%	name	p&??Interface&_&name ?
		endm

;--- STDMETHOD_ expects a return type as first parameter

STDMETHOD_	macro type,name:req,arguments:VARARG
		STDMETHOD name, arguments
		endm

;--- variable number of arguments

STDMETHODV	macro name:req,arguments:VARARG

ifnb <arguments>
%proto&??Interface&_&name& typedef proto c :ptr,&arguments, :VARARG
else
%proto&??Interface&_&name& typedef proto c :ptr, :VARARG
endif

%p&??Interface&_&name& typedef ptr proto&??Interface&_&name

;;??Function	catstr <name>,<	p>,??Interface,<_>,<name>,< ?>
;;??Function
%	name	p&??Interface&_&name ?
		endm


;------------------------------------------------------
; DISPMETHOD macro dummy, do not delete
;------------------------------------------------------

DISPMETHOD macro name:REQ, arguments:VARARG
	endm



CLSCTX_INPROC	EQU	( CLSCTX_INPROC_SERVER  or  CLSCTX_INPROC_HANDLER )
if (_WIN32_WINNT ge 0400h) OR defined(_WIN32_DCOM)
CLSCTX_ALL	EQU	( CLSCTX_INPROC_SERVER  or  CLSCTX_INPROC_HANDLER  or  CLSCTX_LOCAL_SERVER  or  CLSCTX_REMOTE_SERVER )
CLSCTX_SERVER	EQU	( CLSCTX_INPROC_SERVER  or  CLSCTX_LOCAL_SERVER  or  CLSCTX_REMOTE_SERVER )
else 
CLSCTX_ALL	EQU	( CLSCTX_INPROC_SERVER  or  CLSCTX_INPROC_HANDLER  or  CLSCTX_LOCAL_SERVER )
CLSCTX_SERVER	EQU	( CLSCTX_INPROC_SERVER  or  CLSCTX_LOCAL_SERVER )
endif 
REGCLS typedef DWORD
REGCLS_SINGLEUSE = 0 
REGCLS_MULTIPLEUSE = 1 
REGCLS_MULTI_SEPARATE = 2 
REGCLS_SUSPENDED = 4 
REGCLS_SURROGATE = 8 

MARSHALINTERFACE_MIN	EQU	500
CWCSTORAGENAME	EQU	32
STGM_DIRECT	EQU	00000000h
STGM_TRANSACTED	EQU	00010000h
STGM_SIMPLE	EQU	08000000h
STGM_READ	EQU	00000000h
STGM_WRITE	EQU	00000001h
STGM_READWRITE	EQU	00000002h
STGM_SHARE_DENY_NONE	EQU	00000040h
STGM_SHARE_DENY_READ	EQU	00000030h
STGM_SHARE_DENY_WRITE	EQU	00000020h
STGM_SHARE_EXCLUSIVE	EQU	00000010h
STGM_PRIORITY	EQU	00040000h
STGM_DELETEONRELEASE	EQU	04000000h
if (WINVER ge 400)
STGM_NOSCRATCH	EQU	00100000h
endif 
STGM_CREATE	EQU	00001000h
STGM_CONVERT	EQU	00020000h
STGM_FAILIFTHERE	EQU	00000000h
STGM_NOSNAPSHOT	EQU	00200000h
ASYNC_MODE_COMPATIBILITY	EQU	00000001h
ASYNC_MODE_DEFAULT	EQU	00000000h
STGTY_REPEAT	EQU	00000100h
STG_TOEND	EQU	0FFFFFFFFh
STG_LAYOUT_SEQUENTIAL	EQU	00000000h
STG_LAYOUT_INTERLEAVED	EQU	00000001h
STGFMT_STORAGE	EQU	0
STGFMT_NATIVE	EQU	1
STGFMT_FILE	EQU	3
STGFMT_ANY	EQU	4
STGFMT_DOCFILE	EQU	5
STGFMT_DOCUMENT	EQU	0


	include wtypes.inc
	include unknwn.inc
	include objidl.inc

IsEqualGUID proto WINSTDCALLCONV :REFGUID, :REFGUID
    
IsEqualIID macro riid1,riid2
	exitm <IsEqualGUID, riid1 , riid2 >
	endm
IsEqualCLSID macro rclsid1,rclsid2
	exitm <IsEqualGUID, rclsid1 , rclsid2 >
	endm

if 0 eq defined(_OLE32_)
WINOLEAPI equ <DECLSPEC_IMPORT>
else
WINOLEAPI equ <>
endif

@DefProto WINOLEAPI, CoBuildVersion, stdcall, , <>, 0
@DefProto WINOLEAPI, CoInitialize, stdcall, , <:LPVOID>, 4
@DefProto WINOLEAPI, CoUninitialize, stdcall, ,  <>, 0
@DefProto WINOLEAPI, CoGetMalloc, stdcall, , <:DWORD, :ptr LPMALLOC>, 8
@DefProto WINOLEAPI, CoGetCurrentProcess, stdcall, , <>, 0
@DefProto WINOLEAPI, CoRegisterMallocSpy, stdcall, , <:LPMALLOCSPY>, 4
@DefProto WINOLEAPI, CoRevokeMallocSpy, stdcall, , <>, 0
@DefProto WINOLEAPI, CoCreateStandardMalloc, stdcall, , <:DWORD, :ptr ptr IMalloc>, 8

if (_WIN32_WINNT ge 0400h) OR defined(_WIN32_DCOM)
@DefProto WINOLEAPI, CoInitializeEx, stdcall, , <:LPVOID, :DWORD>, 8
endif 

if 0;DBG eq 1
proto_DebugCoGetRpcFault typedef proto WINSTDCALLCONV 
externdef WINSTDCALLCONV _imp__DebugCoGetRpcFault@0: ptr proto_DebugCoGetRpcFault
DebugCoGetRpcFault equ <_imp__DebugCoGetRpcFault@0>
proto_DebugCoSetRpcFault typedef proto WINSTDCALLCONV  :DWORD
externdef WINSTDCALLCONV _imp__DebugCoSetRpcFault@4: ptr proto_DebugCoSetRpcFault
DebugCoSetRpcFault equ <_imp__DebugCoSetRpcFault@4>
endif 

@DefProto WINOLEAPI, CoGetClassObject, stdcall, , <:REFCLSID, :DWORD, :LPVOID, :REFIID, :ptr LPVOID>, 20
@DefProto WINOLEAPI, CoRegisterClassObject, stdcall, , <:REFCLSID, :LPUNKNOWN, :DWORD, :DWORD, :LPDWORD>, 20
@DefProto WINOLEAPI, CoRevokeClassObject, stdcall, , <:DWORD>, 4

proto_CoResumeClassObjects typedef proto WINSTDCALLCONV 
externdef WINSTDCALLCONV _imp__CoResumeClassObjects@0: ptr proto_CoResumeClassObjects
CoResumeClassObjects equ <_imp__CoResumeClassObjects@0>
proto_CoSuspendClassObjects typedef proto WINSTDCALLCONV 
externdef WINSTDCALLCONV _imp__CoSuspendClassObjects@0: ptr proto_CoSuspendClassObjects
CoSuspendClassObjects equ <_imp__CoSuspendClassObjects@0>
proto_CoAddRefServerProcess typedef proto WINSTDCALLCONV 
externdef WINSTDCALLCONV _imp__CoAddRefServerProcess@0: ptr proto_CoAddRefServerProcess
CoAddRefServerProcess equ <_imp__CoAddRefServerProcess@0>
proto_CoReleaseServerProcess typedef proto WINSTDCALLCONV 
externdef WINSTDCALLCONV _imp__CoReleaseServerProcess@0: ptr proto_CoReleaseServerProcess
CoReleaseServerProcess equ <_imp__CoReleaseServerProcess@0>
proto_CoGetPSClsid typedef proto WINSTDCALLCONV  :REFIID, :ptr CLSID
externdef WINSTDCALLCONV _imp__CoGetPSClsid@8: ptr proto_CoGetPSClsid
CoGetPSClsid equ <_imp__CoGetPSClsid@8>
proto_CoRegisterPSClsid typedef proto WINSTDCALLCONV :REFIID, :REFCLSID
externdef WINSTDCALLCONV _imp__CoRegisterPSClsid@8: ptr proto_CoRegisterPSClsid
CoRegisterPSClsid equ <_imp__CoRegisterPSClsid@8>
proto_CoRegisterSurrogate typedef proto WINSTDCALLCONV :LPSURROGATE
externdef WINSTDCALLCONV _imp__CoRegisterSurrogate@4: ptr proto_CoRegisterSurrogate
CoRegisterSurrogate equ <_imp__CoRegisterSurrogate@4>
proto_CoGetMarshalSizeMax typedef proto WINSTDCALLCONV :ptr DWORD, :REFIID, :LPUNKNOWN, :DWORD, :LPVOID, :DWORD
externdef WINSTDCALLCONV _imp__CoGetMarshalSizeMax@24: ptr proto_CoGetMarshalSizeMax
CoGetMarshalSizeMax equ <_imp__CoGetMarshalSizeMax@24>
proto_CoMarshalInterface typedef proto WINSTDCALLCONV :LPSTREAM, :REFIID, :LPUNKNOWN, :DWORD, :LPVOID, :DWORD
externdef WINSTDCALLCONV _imp__CoMarshalInterface@24: ptr proto_CoMarshalInterface
CoMarshalInterface equ <_imp__CoMarshalInterface@24>
proto_CoUnmarshalInterface typedef proto WINSTDCALLCONV :LPSTREAM, :REFIID, :ptr LPVOID
externdef WINSTDCALLCONV _imp__CoUnmarshalInterface@12: ptr proto_CoUnmarshalInterface
CoUnmarshalInterface equ <_imp__CoUnmarshalInterface@12>
proto_CoMarshalHresult typedef proto WINSTDCALLCONV :LPSTREAM, :HRESULT
externdef WINSTDCALLCONV _imp__CoMarshalHresult@8: ptr proto_CoMarshalHresult
CoMarshalHresult equ <_imp__CoMarshalHresult@8>
proto_CoUnmarshalHresult typedef proto WINSTDCALLCONV :LPSTREAM, :ptr HRESULT
externdef WINSTDCALLCONV _imp__CoUnmarshalHresult@8: ptr proto_CoUnmarshalHresult
CoUnmarshalHresult equ <_imp__CoUnmarshalHresult@8>
proto_CoReleaseMarshalData typedef proto WINSTDCALLCONV :LPSTREAM
externdef WINSTDCALLCONV _imp__CoReleaseMarshalData@4: ptr proto_CoReleaseMarshalData
CoReleaseMarshalData equ <_imp__CoReleaseMarshalData@4>
proto_CoDisconnectObject typedef proto WINSTDCALLCONV :LPUNKNOWN, :DWORD
externdef WINSTDCALLCONV _imp__CoDisconnectObject@8: ptr proto_CoDisconnectObject
CoDisconnectObject equ <_imp__CoDisconnectObject@8>
proto_CoLockObjectExternal typedef proto WINSTDCALLCONV :LPUNKNOWN, :BOOL, :BOOL
externdef WINSTDCALLCONV _imp__CoLockObjectExternal@12: ptr proto_CoLockObjectExternal
CoLockObjectExternal equ <_imp__CoLockObjectExternal@12>
proto_CoGetStandardMarshal typedef proto WINSTDCALLCONV :REFIID, :LPUNKNOWN, :DWORD, :LPVOID, :DWORD, :ptr LPMARSHAL
externdef WINSTDCALLCONV _imp__CoGetStandardMarshal@24: ptr proto_CoGetStandardMarshal
CoGetStandardMarshal equ <_imp__CoGetStandardMarshal@24>
proto_CoGetStdMarshalEx typedef proto WINSTDCALLCONV :LPUNKNOWN, :DWORD, :ptr LPUNKNOWN
externdef WINSTDCALLCONV _imp__CoGetStdMarshalEx@12: ptr proto_CoGetStdMarshalEx
CoGetStdMarshalEx equ <_imp__CoGetStdMarshalEx@12>
proto_CoGetStaticMarshal typedef proto WINSTDCALLCONV :ptr IUnknown, :DWORD, :ptr ptr IID, :ptr ptr UUID, :DWORD, :DWORD, :ptr LPUNKNOWN, :ptr ptr IUnknown
externdef WINSTDCALLCONV _imp__CoGetStaticMarshal@32: ptr proto_CoGetStaticMarshal
CoGetStaticMarshal equ <_imp__CoGetStaticMarshal@32>

STDMSHLFLAGS typedef DWORD
SMEXF_SERVER = 01 
SMEXF_HANDLER = 02 

proto_CoIsHandlerConnected typedef proto WINSTDCALLCONV :LPUNKNOWN
externdef WINSTDCALLCONV _imp__CoIsHandlerConnected@4: ptr proto_CoIsHandlerConnected
CoIsHandlerConnected equ <_imp__CoIsHandlerConnected@4>
proto_CoHasStrongExternalConnections typedef proto WINSTDCALLCONV :LPUNKNOWN
externdef WINSTDCALLCONV _imp__CoHasStrongExternalConnections@4: ptr proto_CoHasStrongExternalConnections
CoHasStrongExternalConnections equ <_imp__CoHasStrongExternalConnections@4>
proto_CoMarshalInterThreadInterfaceInStream typedef proto WINSTDCALLCONV :REFIID, :LPUNKNOWN, :ptr LPSTREAM
externdef WINSTDCALLCONV _imp__CoMarshalInterThreadInterfaceInStream@12: ptr proto_CoMarshalInterThreadInterfaceInStream
CoMarshalInterThreadInterfaceInStream equ <_imp__CoMarshalInterThreadInterfaceInStream@12>
proto_CoGetInterfaceAndReleaseStream typedef proto WINSTDCALLCONV :LPSTREAM, :REFIID, :ptr LPVOID
externdef WINSTDCALLCONV _imp__CoGetInterfaceAndReleaseStream@12: ptr proto_CoGetInterfaceAndReleaseStream
CoGetInterfaceAndReleaseStream equ <_imp__CoGetInterfaceAndReleaseStream@12>
proto_CoCreateFreeThreadedMarshaler typedef proto WINSTDCALLCONV :LPUNKNOWN, :ptr LPUNKNOWN
externdef WINSTDCALLCONV _imp__CoCreateFreeThreadedMarshaler@8: ptr proto_CoCreateFreeThreadedMarshaler
CoCreateFreeThreadedMarshaler equ <_imp__CoCreateFreeThreadedMarshaler@8>
proto_CoLoadLibrary typedef proto WINSTDCALLCONV :LPOLESTR, :BOOL
externdef WINSTDCALLCONV _imp__CoLoadLibrary@8: ptr proto_CoLoadLibrary
CoLoadLibrary equ <_imp__CoLoadLibrary@8>
proto_CoFreeLibrary typedef proto WINSTDCALLCONV :HINSTANCE
externdef WINSTDCALLCONV _imp__CoFreeLibrary@4: ptr proto_CoFreeLibrary
CoFreeLibrary equ <_imp__CoFreeLibrary@4>
proto_CoFreeAllLibraries typedef proto WINSTDCALLCONV
externdef WINSTDCALLCONV _imp__CoFreeAllLibraries@0: ptr proto_CoFreeAllLibraries
CoFreeAllLibraries equ <_imp__CoFreeAllLibraries@0>
proto_CoFreeUnusedLibraries typedef proto WINSTDCALLCONV
externdef WINSTDCALLCONV _imp__CoFreeUnusedLibraries@0: ptr proto_CoFreeUnusedLibraries
CoFreeUnusedLibraries equ <_imp__CoFreeUnusedLibraries@0>

if (_WIN32_WINNT ge 0400h) OR defined(_WIN32_DCOM)
proto_CoInitializeSecurity typedef proto WINSTDCALLCONV :PSECURITY_DESCRIPTOR, :SDWORD, :ptr SOLE_AUTHENTICATION_SERVICE, :ptr , :DWORD, :DWORD, :ptr , :DWORD, :ptr 
externdef WINSTDCALLCONV _imp__CoInitializeSecurity@36: ptr proto_CoInitializeSecurity
CoInitializeSecurity equ <_imp__CoInitializeSecurity@36>
proto_CoGetCallContext typedef proto WINSTDCALLCONV :REFIID, :ptr ptr 
externdef WINSTDCALLCONV _imp__CoGetCallContext@8: ptr proto_CoGetCallContext
CoGetCallContext equ <_imp__CoGetCallContext@8>
proto_CoQueryProxyBlanket typedef proto WINSTDCALLCONV :ptr IUnknown, :ptr DWORD, :ptr DWORD, :ptr ptr OLECHAR, :ptr DWORD, :ptr DWORD, :ptr RPC_AUTH_IDENTITY_HANDLE, :ptr DWORD
externdef WINSTDCALLCONV _imp__CoQueryProxyBlanket@32: ptr proto_CoQueryProxyBlanket
CoQueryProxyBlanket equ <_imp__CoQueryProxyBlanket@32>
proto_CoSetProxyBlanket typedef proto WINSTDCALLCONV  :ptr IUnknown, :DWORD, :DWORD, :ptr OLECHAR, :DWORD, :DWORD, :RPC_AUTH_IDENTITY_HANDLE, :DWORD
externdef WINSTDCALLCONV _imp__CoSetProxyBlanket@32: ptr proto_CoSetProxyBlanket
CoSetProxyBlanket equ <_imp__CoSetProxyBlanket@32>
proto_CoCopyProxy typedef proto WINSTDCALLCONV  :ptr IUnknown, :ptr ptr IUnknown
externdef WINSTDCALLCONV _imp__CoCopyProxy@8: ptr proto_CoCopyProxy
CoCopyProxy equ <_imp__CoCopyProxy@8>
proto_CoQueryClientBlanket typedef proto WINSTDCALLCONV  :ptr DWORD, :ptr DWORD, :ptr ptr OLECHAR, :ptr DWORD, :ptr DWORD, :ptr RPC_AUTHZ_HANDLE, :ptr DWORD
externdef WINSTDCALLCONV _imp__CoQueryClientBlanket@28: ptr proto_CoQueryClientBlanket
CoQueryClientBlanket equ <_imp__CoQueryClientBlanket@28>
proto_CoImpersonateClient typedef proto WINSTDCALLCONV 
externdef WINSTDCALLCONV _imp__CoImpersonateClient@0: ptr proto_CoImpersonateClient
CoImpersonateClient equ <_imp__CoImpersonateClient@0>
proto_CoRevertToSelf typedef proto WINSTDCALLCONV 
externdef WINSTDCALLCONV _imp__CoRevertToSelf@0: ptr proto_CoRevertToSelf
CoRevertToSelf equ <_imp__CoRevertToSelf@0>
proto_CoQueryAuthenticationServices typedef proto WINSTDCALLCONV  :ptr DWORD, :ptr ptr SOLE_AUTHENTICATION_SERVICE
externdef WINSTDCALLCONV _imp__CoQueryAuthenticationServices@8: ptr proto_CoQueryAuthenticationServices
CoQueryAuthenticationServices equ <_imp__CoQueryAuthenticationServices@8>
proto_CoSwitchCallContext typedef proto WINSTDCALLCONV  :ptr IUnknown, :ptr ptr IUnknown
externdef WINSTDCALLCONV _imp__CoSwitchCallContext@8: ptr proto_CoSwitchCallContext
CoSwitchCallContext equ <_imp__CoSwitchCallContext@8>
COM_RIGHTS_EXECUTE	EQU	1
endif 

proto_CoCreateInstance typedef proto WINSTDCALLCONV  :REFCLSID, :LPUNKNOWN, :DWORD, :REFIID, :ptr LPVOID
externdef WINSTDCALLCONV _imp__CoCreateInstance@20: ptr proto_CoCreateInstance
CoCreateInstance equ <_imp__CoCreateInstance@20>

if (_WIN32_WINNT ge 0400h) OR defined(_WIN32_DCOM)
proto_CoGetInstanceFromFile typedef proto WINSTDCALLCONV :ptr COSERVERINFO, :ptr CLSID, :ptr IUnknown, :DWORD, :DWORD, :ptr OLECHAR, :DWORD, :ptr MULTI_QI
externdef WINSTDCALLCONV _imp__CoGetInstanceFromFile@32: ptr proto_CoGetInstanceFromFile
CoGetInstanceFromFile equ <_imp__CoGetInstanceFromFile@32>
proto_CoGetInstanceFromIStorage typedef proto WINSTDCALLCONV :ptr COSERVERINFO, :ptr CLSID, :ptr IUnknown, :DWORD, :ptr IStorage, :DWORD, :ptr MULTI_QI
externdef WINSTDCALLCONV _imp__CoGetInstanceFromIStorage@28: ptr proto_CoGetInstanceFromIStorage
CoGetInstanceFromIStorage equ <_imp__CoGetInstanceFromIStorage@28>
proto_CoCreateInstanceEx typedef proto WINSTDCALLCONV  :REFCLSID, :ptr IUnknown, :DWORD, :ptr COSERVERINFO, :DWORD, :ptr MULTI_QI
externdef WINSTDCALLCONV _imp__CoCreateInstanceEx@24: ptr proto_CoCreateInstanceEx
CoCreateInstanceEx equ <_imp__CoCreateInstanceEx@24>
endif 

if (_WIN32_WINNT ge 0500h) OR defined(_WIN32_DCOM)
@DefProto WINOLEAPI, CoGetCancelObject, stdcall, , <:DWORD, :REFIID, :ptr ptr>, 12
@DefProto WINOLEAPI, CoSetCancelObject, stdcall, , <:ptr IUnknown>, 4
@DefProto WINOLEAPI, CoCancelCall, stdcall, , <:DWORD>, 4
@DefProto WINOLEAPI, CoTestCancel, stdcall, , <>, 0 
endif 

if (_WIN32_WINNT ge 0500h) OR defined(_WIN32_DCOM)
@DefProto WINOLEAPI, CoGetClassInfo, stdcall, , <:ptr uCLSSPEC, :ptr QUERYCONTEXT>, 8
@DefProto WINOLEAPI, CoGetClassAccess, stdcall, , <:ptr ptr IClassAccess>, 4
@DefProto WINOLEAPI, CoGetPublishedAppInfo, stdcall, , <:APPINFOTYPE, :ptr DWORD, :ptr ptr PUBLISHEDAPPINFO>, 12
endif 

@DefProto WINOLEAPI, StringFromCLSID, stdcall, , <:REFCLSID, :ptr LPOLESTR>, 8
@DefProto WINOLEAPI, CLSIDFromString, stdcall, , <:LPOLESTR, :LPCLSID>, 8
@DefProto WINOLEAPI, StringFromIID, stdcall, , <:REFIID, :ptr LPOLESTR>, 8
@DefProto WINOLEAPI, IIDFromString, stdcall, , <:LPOLESTR, :LPIID>, 8
@DefProto WINOLEAPI, CoIsOle1Class, stdcall, , <:REFCLSID>, 4
@DefProto WINOLEAPI, ProgIDFromCLSID, stdcall, , <:REFCLSID, :ptr LPOLESTR>, 8
@DefProto WINOLEAPI, CLSIDFromProgID, stdcall, , <:LPCOLESTR, :LPCLSID>, 8
@DefProto WINOLEAPI, StringFromGUID2, stdcall, , <:REFGUID, :LPOLESTR, :DWORD>, 12
@DefProto WINOLEAPI, CoCreateGuid, stdcall, , <:ptr GUID>, 4
@DefProto WINOLEAPI, CoFileTimeToDosDateTime, stdcall, , <:ptr FILETIME, :LPWORD, :LPWORD>, 12
@DefProto WINOLEAPI, CoDosDateTimeToFileTime, stdcall, , <:WORD, :WORD, :ptr FILETIME>, 12
@DefProto WINOLEAPI, CoFileTimeNow, stdcall, , <:ptr FILETIME>, 4
@DefProto WINOLEAPI, CoRegisterMessageFilter, stdcall, , <:LPMESSAGEFILTER, :ptr LPMESSAGEFILTER>, 8

if (_WIN32_WINNT ge 0400h) OR defined(_WIN32_DCOM)
@DefProto WINOLEAPI, CoRegisterChannelHook, stdcall, , <:REFGUID, :ptr IChannelHook>, 8
endif 

@DefProto WINOLEAPI, CoGetTreatAsClass, stdcall, , <:REFCLSID, :LPCLSID>, 8
@DefProto WINOLEAPI, CoTreatAsClass, stdcall, ,<:REFCLSID, :REFCLSID>, 8

proto_LPFNGETCLASSOBJECT typedef proto WINSTDCALLCONV :REFCLSID,:REFIID,:ptr LPVOID
LPFNGETCLASSOBJECT typedef ptr proto_LPFNGETCLASSOBJECT
proto_LPFNCANUNLOADNOW typedef proto WINSTDCALLCONV
LPFNCANUNLOADNOW typedef ptr proto_LPFNCANUNLOADNOW

if 0
@DefProto WINOLEAPI, DllGetClassObject, stdcall, , <:REFCLSID, :REFIID, :ptr LPVOID>, 12
@DefProto WINOLEAPI, DllCanUnloadNow, stdcall, , <>, 0 
endif

@DefProto WINOLEAPI, CoTaskMemAlloc, stdcall, , <:DWORD>, 4
@DefProto WINOLEAPI, CoTaskMemRealloc, stdcall, , <:LPVOID, :DWORD>, 8
@DefProto WINOLEAPI, CoTaskMemFree, stdcall, , <:LPVOID>, 4
@DefProto WINOLEAPI, CreateDataAdviseHolder, stdcall, , <:ptr LPDATAADVISEHOLDER>, 4
@DefProto WINOLEAPI, CreateDataCache, stdcall, , <:LPUNKNOWN, :REFCLSID, :REFIID, :ptr LPVOID>, 16
@DefProto WINOLEAPI, StgCreateDocfile, stdcall, , <:ptr OLECHAR, :DWORD, :DWORD, :ptr ptr IStorage>, 16
@DefProto WINOLEAPI, StgCreateDocfileOnILockBytes, stdcall, , <:ptr ILockBytes, :DWORD, :DWORD, :ptr ptr IStorage>, 16
@DefProto WINOLEAPI, StgOpenStorage, stdcall, , <:ptr OLECHAR, :ptr IStorage, :DWORD, :SNB, :DWORD, :ptr ptr IStorage>, 24
@DefProto WINOLEAPI, StgOpenStorageOnILockBytes, stdcall, , <:ptr ILockBytes, :ptr IStorage, :DWORD, :SNB, :DWORD, :ptr ptr IStorage>, 24
@DefProto WINOLEAPI, StgIsStorageFile, stdcall, , <:ptr OLECHAR>, 4
@DefProto WINOLEAPI, StgIsStorageILockBytes, stdcall, , <:ptr ILockBytes>, 4
@DefProto WINOLEAPI, StgSetTimes, stdcall, , <:ptr OLECHAR, :ptr FILETIME, :ptr FILETIME, :ptr FILETIME>, 16
@DefProto WINOLEAPI, StgOpenAsyncDocfileOnIFillLockBytes, stdcall, , <:ptr IFillLockBytes, :DWORD, :DWORD, :ptr ptr IStorage>, 16
@DefProto WINOLEAPI, StgGetIFillLockBytesOnILockBytes, stdcall, , <:ptr ILockBytes, :ptr ptr IFillLockBytes>, 8
@DefProto WINOLEAPI, StgGetIFillLockBytesOnFile, stdcall, , <:ptr OLECHAR, :ptr ptr IFillLockBytes>, 8
@DefProto WINOLEAPI, StgOpenLayoutDocfile, stdcall, , <:ptr OLECHAR, :DWORD, :DWORD, :ptr ptr IStorage>, 16
@DefProto WINOLEAPI, StgCreateStorageEx, stdcall, , <:ptr WCHAR, :DWORD, :DWORD, :DWORD, :ptr , :ptr , :REFIID, :ptr ptr>, 32
@DefProto WINOLEAPI, StgOpenStorageEx, stdcall, , <:ptr WCHAR, :DWORD, :DWORD, :DWORD, :ptr , :ptr , :REFIID, :ptr ptr>, 32

proto_BindMoniker typedef proto WINSTDCALLCONV  :LPMONIKER, :DWORD, :REFIID, :ptr LPVOID
externdef WINSTDCALLCONV _imp__BindMoniker@16: ptr proto_BindMoniker
BindMoniker equ <_imp__BindMoniker@16>
proto_CoInstall typedef proto WINSTDCALLCONV  :ptr IBindCtx, :DWORD, :ptr uCLSSPEC, :ptr QUERYCONTEXT, :LPWSTR
externdef WINSTDCALLCONV _imp__CoInstall@20: ptr proto_CoInstall
CoInstall equ <_imp__CoInstall@20>
proto_CoGetObject typedef proto WINSTDCALLCONV  :LPWSTR, :ptr BIND_OPTS, :REFIID, :ptr ptr 
externdef WINSTDCALLCONV _imp__CoGetObject@16: ptr proto_CoGetObject
CoGetObject equ <_imp__CoGetObject@16>
proto_MkParseDisplayName typedef proto WINSTDCALLCONV  :LPBC, :LPCOLESTR, :ptr DWORD, :ptr LPMONIKER
externdef WINSTDCALLCONV _imp__MkParseDisplayName@16: ptr proto_MkParseDisplayName
MkParseDisplayName equ <_imp__MkParseDisplayName@16>
proto_MonikerRelativePathTo typedef proto WINSTDCALLCONV  :LPMONIKER, :LPMONIKER, :ptr LPMONIKER, :BOOL
externdef WINSTDCALLCONV _imp__MonikerRelativePathTo@16: ptr proto_MonikerRelativePathTo
MonikerRelativePathTo equ <_imp__MonikerRelativePathTo@16>
proto_MonikerCommonPrefixWith typedef proto WINSTDCALLCONV  :LPMONIKER, :LPMONIKER, :ptr LPMONIKER
externdef WINSTDCALLCONV _imp__MonikerCommonPrefixWith@12: ptr proto_MonikerCommonPrefixWith
MonikerCommonPrefixWith equ <_imp__MonikerCommonPrefixWith@12>
proto_CreateBindCtx typedef proto WINSTDCALLCONV  :DWORD, :ptr LPBC
externdef WINSTDCALLCONV _imp__CreateBindCtx@8: ptr proto_CreateBindCtx
CreateBindCtx equ <_imp__CreateBindCtx@8>
proto_CreateGenericComposite typedef proto WINSTDCALLCONV  :LPMONIKER, :LPMONIKER, :ptr LPMONIKER
externdef WINSTDCALLCONV _imp__CreateGenericComposite@12: ptr proto_CreateGenericComposite
CreateGenericComposite equ <_imp__CreateGenericComposite@12>
proto_GetClassFile typedef proto WINSTDCALLCONV  :LPCOLESTR, :ptr CLSID
externdef WINSTDCALLCONV _imp__GetClassFile@8: ptr proto_GetClassFile
GetClassFile equ <_imp__GetClassFile@8>
proto_CreateClassMoniker typedef proto WINSTDCALLCONV  :REFCLSID, :ptr LPMONIKER
externdef WINSTDCALLCONV _imp__CreateClassMoniker@8: ptr proto_CreateClassMoniker
CreateClassMoniker equ <_imp__CreateClassMoniker@8>
proto_CreateFileMoniker typedef proto WINSTDCALLCONV  :LPCOLESTR, :ptr LPMONIKER
externdef WINSTDCALLCONV _imp__CreateFileMoniker@8: ptr proto_CreateFileMoniker
CreateFileMoniker equ <_imp__CreateFileMoniker@8>
proto_CreateItemMoniker typedef proto WINSTDCALLCONV  :LPCOLESTR, :LPCOLESTR, :ptr LPMONIKER
externdef WINSTDCALLCONV _imp__CreateItemMoniker@12: ptr proto_CreateItemMoniker
CreateItemMoniker equ <_imp__CreateItemMoniker@12>
proto_CreateAntiMoniker typedef proto WINSTDCALLCONV  :ptr LPMONIKER
externdef WINSTDCALLCONV _imp__CreateAntiMoniker@4: ptr proto_CreateAntiMoniker
CreateAntiMoniker equ <_imp__CreateAntiMoniker@4>
proto_CreatePointerMoniker typedef proto WINSTDCALLCONV  :LPUNKNOWN, :ptr LPMONIKER
externdef WINSTDCALLCONV _imp__CreatePointerMoniker@8: ptr proto_CreatePointerMoniker
CreatePointerMoniker equ <_imp__CreatePointerMoniker@8>
proto_GetRunningObjectTable typedef proto WINSTDCALLCONV  :DWORD, :ptr LPRUNNINGOBJECTTABLE
externdef WINSTDCALLCONV _imp__GetRunningObjectTable@8: ptr proto_GetRunningObjectTable
GetRunningObjectTable equ <_imp__GetRunningObjectTable@8>

	include urlmon.inc

proto_CreateStdProgressIndicator typedef proto WINSTDCALLCONV  :HWND, :LPCOLESTR, :ptr IBindStatusCallback, :ptr ptr IBindStatusCallback
externdef WINSTDCALLCONV _imp__CreateStdProgressIndicator@16: ptr proto_CreateStdProgressIndicator
CreateStdProgressIndicator equ <_imp__CreateStdProgressIndicator@16>

endif	;ifndef _OBJBASE_H_
;;--- end of file
