



        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Data Structures and Definitions                              ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos                                                ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This product is distributed  AS IS and contains no warranty  ;
        ;  whatsoever,   including  warranty  of   merchantability  or  ;
        ;  fitness for a particular purpose.                            ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1999. Mike Podanoffsky                   ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This is free software; you can redistribute it and/or modify ;
        ;  it under the terms of the GNU General Public License, see    ;
        ;  the file COPYING.                                            ;
        ;                                                               ;
        ;  mail: mike.podanoffsky@mindspring.com                        ;
        ;                                                               ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;  Compile with MASM 5.1                                        ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Set ROM IDENTIFICATION                                       ;
        ;...............................................................;

 IFDEF RxDOS_ROMVERSION
ROM_IDENTIFICATION              equ 8                       ; ROM Version Status

 ELSE
ROM_IDENTIFICATION              equ 0                       ; not in ROM 

 ENDIF


        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Default Configuration Parameters                             ;
        ;...............................................................;

DEFAULT_FILES                   equ 16                      ; MS DOS default is 8
DEFAULT_FCBS                    equ 4                       ; MS DOS default is 4
DEFAULT_BUFFERS                 equ 30                      ; MS DOS default is 2
DEFAULT_LASTDRIVE               equ 'E'                     ; MS DOS default is e:
DEFAULT_FCBOPENMODE             equ 2                       ; change only if you want read-only
DEFAULT_STACKS                  equ 9                       ; 
DEFAULT_CODEPAGE                equ CODEPAGE_UNITEDSTATES   ; default code page
DEFAULT_COUNTRYCODE             equ COUNTRY_UNITEDSTATES    ; default country code

DEFAULT_MINENVIRONMENT          equ 2048                    ; bytes default environment space
DEFAULT_MINALLOWEDENVIRONMENT   equ 160                     ; MS DOS minimum
DEFAULT_MAXALLOWEDENVIRONMENT   equ 32768                   ; MS DOS maximum

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Max Configuration Parameters Allowable                       ;
        ;...............................................................;

        ; max allowed values, not actual values

CONFIGMAX_FILES                 equ 255                 ; MS DOS default is 8 (value is max allowed)
CONFIGMAX_BUFFERS               equ 99                  ; MS DOS default is 2 (value is max allowed)
CONFIGMAX_FCBS_X                equ 255                 ; MS DOS default is 4 (value is max allowed)
CONFIGMAX_FCBS_Y                equ 255                 ; MS DOS default is 0 (value is max allowed)

CONFIGMIN_STACKS_X              equ  8                  ; MS DOS default is 9
CONFIGMAX_STACKS_X              equ 64

CONFIGMIN_STACKS_Y              equ 32                  ; MS DOS default is 128
CONFIGMAX_STACKS_Y              equ 512

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DOS Functions                                                ;
        ;...............................................................;

ProgramTerminate                equ 00h                 ; Program Terminate
KeyboardInput                   equ 01h                 ; Keyboard Input
DisplayOutput                   equ 02h                 ; Display Output
AuxInput                        equ 03h                 ; Aux Input
AuxOutput                       equ 04h                 ; Aux Output
PrinterOutput                   equ 05h                 ; Printer Output
DirectConsole                   equ 06h                 ; Direct Console
DirectConsoleInputNoEcho        equ 07h                 ; Direct Console Input NoEcho
ConsoleInputNoEcho              equ 08h                 ; Console Input NoEcho
DisplayString                   equ 09h                 ; Display String
BufferedKeyboardInput           equ 0Ah                 ; Buffered keyboard input
GetLine                         equ BufferedKeyboardInput
CheckKeyboardInput              equ 0Bh                 ; Check keyboard input
ClearBufferedKeyboardInput      equ 0Ch                 ; Clear Buffered keyboard input
DiskReset                       equ 0Dh                 ; Disk reset
SelectDisk                      equ 0Eh                 ; Se*lect disk
OpenFileFCB                     equ 0Fh                 ; Open file FCB
CloseFileFCB                    equ 10h                 ; Close file FCB
SearchFirstFileFCB              equ 11h                 ; Search first file FCB
SearchNextFileFCB               equ 12h                 ; Search next file FCB
DeleteFileFCB                   equ 13h                 ; Delete file FCB
SeqReadFileFCB                  equ 14h                 ; Seq read file FCB
SeqWriteFileFCB                 equ 15h                 ; Seq write file FCB
CreateFileFCB                   equ 16h                 ; Create file FCB
RenameFileFCB                   equ 17h                 ; Rename file FCB
CurrentDisk                     equ 19h                 ; Current disk
SetDiskTransferAddress          equ 1Ah                 ; Set disk transfer address
SetDTA                          equ SetDiskTransferAddress
GetDefaultDriveData             equ 1Bh                 ; Get Default Drive Data
GetDriveData                    equ 1Ch                 ; Get Drive Data
GetDefaultDriveParameterBlock   equ 1Fh                 ; Get Default Drive Parameter Block
ReadFileFCB                     equ 21h                 ; Read file FCB
WriteFileFCB                    equ 22h                 ; Write file FCB
FileSizeFCB                     equ 23h                 ; File size FCB
SetRelativeRecordFCB            equ 24h                 ; Set relative record FCB
SetIntVector                    equ 25h                 ; Set interrupt vector
CreateNewProgramSeg             equ 26h                 ; Create new program seg
RandomBlockReadFCB              equ 27h                 ; Random block read FCB
RandomBlockWriteFCB             equ 28h                 ; Random block write FCB
ParseFilenameFCB                equ 29h                 ; Parse filename FCB
GetDate                         equ 2Ah                 ; Get date 
SetDate                         equ 2Bh                 ; Set date
GetTime                         equ 2Ch                 ; Get time
SetTime                         equ 2Dh                 ; Set time
SetVerifySwitch                 equ 2Eh                 ; Set verify switch
GetDiskTransferAddress          equ 2Fh                 ; Get disk transfer address
GetDTA                          equ GetDiskTransferAddress
GetDOSVersion                   equ 30h                 ; Get DOS version
TerminateStayResident           equ 31h                 ; Terminate stay resident
GetDriveParameterBlock          equ 32h                 ; Undocumented (Get Drive Parameter Block)
CtrlBreakCheck                  equ 33h                 ; Ctrl break check
GetINDOSFlagAddress             equ 34h                 ; Get INDOS Flag Address
GetIntVector                    equ 35h                 ; Get interrupt vector
GetFreeDiskSpace                equ 36h                 ; Get free disk space
GetSetSwitchChar                equ 37h                 ; Get/set switch char
CountryDependentInfo            equ 38h                 ; Country dependent info
CreateSubdirectory              equ 39h                 ; Create subdirectory
RemoveSubdirectory              equ 3Ah                 ; Remove subdirectory
ChangeSubdirectory              equ 3Bh                 ; Change subdirectory
CreateFile                      equ 3Ch                 ; Create file
OpenFile                        equ 3Dh                 ; Open file
CloseFile                       equ 3Eh                 ; Close file
ReadFile                        equ 3Fh                 ; Read file
WriteFile                       equ 40h                 ; Write file
DeleteFile                      equ 41h                 ; Delete file
MoveFilePointer                 equ 42h                 ; Move file pointer
ChangeFileMode                  equ 43h                 ; Change file mode
IoControl                       equ 44h                 ; Io Control
DuplicateFileHandle             equ 45h                 ; Duplicate file handle
ForceFileHandle                 equ 46h                 ; Force file handle
GetCurrentDirectory             equ 47h                 ; Get current directory
AllocateMemory                  equ 48h                 ; Allocate memory
FreeAllocatedMemory             equ 49h                 ; Free allocated memory
ModifyAllocatedMemory           equ 4Ah                 ; Modify allocated memory
ExecuteProgram                  equ 4Bh                 ; ExecuteProgram
TerminateProcess                equ 4Ch                 ; Terminate process
TerminateProgram                equ TerminateProcess
GetReturnCode                   equ 4Dh                 ; Get return code
FindFirstFile                   equ 4Eh                 ; Find first file
FindNextFile                    equ 4Fh                 ; Find next file
SetPSPAddress                   equ 50h                 ; Set PSP Address
GetPSPAddress                   equ 51h                 ; Get PSP Address
GetDosDataTablePtr              equ 52h                 ; Undocumented (Get DOS Data Table)
GetVerify                       equ 54h                 ; Get verify
DuplicatePSP                    equ 55h                 ; Duplicate PSP
RenameFile                      equ 56h                 ; Rename file
SetFileDateTime                 equ 57h                 ; Set file date time
GetAllocationStrategy           equ 5800h               ; Get allocation strategy
SetAllocationStrategy           equ 5801h               ; Set allocation strategy
GetExtendedError                equ 59h                 ; Get extended error
CreateUniqueFile                equ 5Ah                 ; Create unique file
CreateNewFile                   equ 5Bh                 ; Create new file
LockFileAccess                  equ 5Ch                 ; Lock file access
ServerShareAndSwap              equ 5Dh                 ; Server Share/ Swap 
SetExtendedError                equ 5D0Ah               ; Set Extended Error
GetMachineName                  equ 5Eh                 ; Get machine name
GetRedirectionList              equ 5Fh                 ; Get redirection list
GetActualFileName               equ 60h                 ; Undocumented (Get Actual FileName)
GetProgramSegmentPrefix         equ 62h                 ; Get program segment prefix
ExtCountryDependentFunctions    equ 65h                 ; Country Dependent Functions
SetHandlesCount                 equ 67h                 ; Set Handles Count
CommitFile                      equ 68h                 ; Commit File
GetDiskSerialNumber             equ 69h                 ; Get Disk Serial Number  
ExtendedOpenCreate              equ 6Ch                 ; Extended Open/ Create

GetVolumeInformation            equ 0A0h
FindClose                       equ 0A1h
GetFileInfoByHandle             equ 0A6h
FileTime                        equ 0A7h
GenerateShortName               equ 0A8h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  71xxh Extended Functions                                     ;
        ;...............................................................;

LFNCreateSubdirectory           equ 7139h               ; Create subdirectory
LFNRemoveSubdirectory           equ 713Ah               ; Remove subdirectory
LFNChangeSubdirectory           equ 713Bh               ; Change subdirectory

LFNDeleteFile                   equ 7141h               ; Delete file
LFNChangeFileMode               equ 7143h               ; Change file mode
LFNGetCurrentDirectory          equ 7147h               ; Get current directory
LFNExecuteProgram               equ 714Bh               ; Execute program
LFNFindFirstFile                equ 714Eh               ; Find first file
LFNFindNextFile                 equ 714Fh               ; Find next file
LFNRenameFile                   equ 7156h               ; Rename file
LFNGetActualFileName            equ 7160h               ; Get actual file name
LFNExtendedOpenCreate           equ 716Ch               ; Extended open create

LFNGetVolumeInformation         equ 71A0h               ; Get volume information
LFNFindClose                    equ 71A1h               ; Find close
LFNGetFileInfoByHandle          equ 71A6h               ; Get file info by handle
LFNFileTime                     equ 71A7h               ; File time
LFNGenerateShortName            equ 71A8h               ; Generate short name

LFNServerOpenFile               equ 71A9h               ; Server open file
LFNSubst                        equ 71AAh               ; Subst

LFNGetActualFileName            equ 7160h               ; Get actual file name
LFNGetActualFileName            equ 7160h               ; Get actual file name

LFNGetExtDPB                    equ 7302h               ; get FAT32 extended DPB
LFNGetExtFreeSpace              equ 7303h               ; get FAT32 extended free space


        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Network Redirector (2F11) Functions                          ;
        ;...............................................................;

IFSInstallCheck                 equ 00h                 ; Install Check
IFSRemoveDirectory              equ 01h                 ; Remove Directory
IFSMakeDirectory                equ 03h                 ; Make Directory
IFSChangeDirectory              equ 05h                 ; Change Directory
IFSCloseFile                    equ 06h                 ; Close File
IFSCommitFile                   equ 07h                 ; Commit File
IFSReadFile                     equ 08h                 ; Read File
IFSWriteFile                    equ 09h                 ; Write File
IFSLockRegion                   equ 0Ah                 ; Lock Region
IFSUnlockRegion                 equ 0Bh                 ; Unlock Region
IFSGetDiskSpace                 equ 0Ch                 ; Get Disk Space
IFSSetFileAttributes            equ 0Eh                 ; Set File Attributes
IFSGetFileAttributes            equ 0Fh                 ; Get File Attributes
IFSRenameFile                   equ 11h                 ; Rename File
IFSDeleteFile                   equ 13h                 ; Delete File
IFSOpenFile                     equ 16h                 ; Open File
IFSCreateFile                   equ 17h                 ; Create File
IFSFindFirst                    equ 1Bh                 ; Find First
IFSFindNext                     equ 1Ch                 ; Find Next
IFSCloseAllFiles                equ 1Dh                 ; Close All Files
IFSSetRedirection               equ 1Eh                 ; Set Redirection
IFSPrinterSetup                 equ 1Fh                 ; Printer Setup
IFSFlushBuffers                 equ 20h                 ; Flush Buffers
IFSSeekFromEnd                  equ 21h                 ; Seek From End
IFSTerminateProcess             equ 22h                 ; Terminate Process
IFSQualifyFilename              equ 23h                 ; Qualify Filename
IFSPrinterMode                  equ 25h                 ; Printer Mode
IFSPrinterOnOff                 equ 26h                 ; Printer On/Off
IFSCopy                         equ 27h                 ; Copy
IFSIOCTL                        equ 2Bh                 ; IOCTL
IFSExpandedOpen                 equ 2Eh                 ; Expanded Open/Create
IFSGetSegment                   equ 30h                 ; Get NFS Segment

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Interrupt Definitions                                        ;
        ;...............................................................;

intTERMINATEAPP                 equ 22h                 ; terminate app 
intCONTROLC                     equ 23h                 ; control-c handler
intCRITICALERROR                equ 24h                 ; critical error

intIDLELOOP                     equ 28h                 ; let other applications run

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Standard I/O Definitions                                     ;
        ;...............................................................;

STDIN                           equ 00
STDOUT                          equ 01
STDERR                          equ 02
STDAUX                          equ 03
STDPRN                          equ 04

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Seek Definitions                                             ;
        ;...............................................................;

SEEK_BEG                        equ 00
SEEK_CUR                        equ 01
SEEK_END                        equ 02

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Open Modes                                                   ;
        ;...............................................................;

OPEN_ACCESS_READONLY            equ 00h
OPEN_ACCESS_WRITEONLY           equ 01h
OPEN_ACCESS_READWRITE           equ 02h
OPEN_ACCESS_NOINHERIT           equ 80h

OPEN_SHARE_COMPATABILITY        equ 00h
OPEN_SHARE_DENYREADWRITE        equ 10h
OPEN_SHARE_DENYREAD             equ 20h
OPEN_SHARE_DENYWRITE            equ 30h
OPEN_SHARE_DENYNONE             equ 40h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  File Actions                                                 ;
        ;...............................................................;

ACTION_OPENED                   equ 01
ACTION_CREATED_OPENED           equ 02
ACTION_REPLACED_OPENED          equ 03

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Extended Open / Create Actions                               ;
        ;...............................................................;

EXTENDEDACTION_CREATE           equ 0010h
EXTENDEDACTION_OPEN             equ 0001h               ; fail if exists
EXTENDEDACTION_TRUNCATE         equ 0002h               ; create or open

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Expand Filename options                                      ;
        ;...............................................................;

LFNEXPAND_GETFULLPATHNAME        equ 0                  ; 7160 GetFullPathName
LFNEXPAND_GETSHORTPATHNAME       equ 1                  ; 7160 GetShortPathName
LFNEXPAND_GETLONGPATHNAME        equ 2                  ; 7160 GetLongPathName

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  FCB Parse                                                    ;
        ;...............................................................;

FCBPARSE_IGNORELEADSEPARATOR     equ 01
FCBPARSE_LEAVEDRIVEUNCHANGED     equ 02
FCBPARSE_LEAVEFILENAMEUNCHANGED  equ 04
FCBPARSE_LEAVEEXTENSIONUNCHANGED equ 08

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Control Check Definitions                                    ;
        ;...............................................................;

getControlC                     equ 00h                 ; Get ControlC Check Flag
setControlC                     equ 01h                 ; Set ControlC Check Flag
getStartupDrive                 equ 05h                 ; Get Startup Drive
getExtDosVersion                equ 06h                 ; Get DOS Version

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Load and Exec Subfunctions                                   ;
        ;...............................................................;

execLoadAndExecute              equ 00h                 ; load and execute
execLoadAndReturnDebug          equ 01h                 ; load and return to debugger
execLoadOverlay                 equ 03h                 ; load overlay
execSetExecuteMode              equ 05h                 ; set execution mode

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Terminate Codes                                              ;
        ;...............................................................;

TERMINATE_NORMAL                equ 00h                 ; process completed with a 4C 
TERMINATE_CONTROLC              equ 01h                 ; process was cancelled
TERMINATE_DEVICEERROR           equ 02h                 ; abort in device handler
TERMINATE_TSR                   equ 03h                 ; terminated but stayed resident

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  65h Country Dependent Capitalization                         ;
        ;...............................................................;

_CapCharacter                   equ  20h                ; character capitalization
_CapLengthDefString             equ  21h                ; length defined string capitalization
_CapString                      equ  22h                ; ASCIZ capitalization
_CountryDepYesNo                equ  23h                ; does character represent Yes/No response
_CapFnCharacter                 equ 0A0h                ; filename character capitalization
_CapFnLengthDefString           equ 0A1h                ; filename length defined string capitalization
_CapFnString                    equ 0A2h                ; filename ASCIZ capitalization

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Country Codes                                                ;
        ;...............................................................;

COUNTRY_UNITEDSTATES            equ 001                 ; United States
COUNTRY_CANADIANFRENCH          equ 002                 ; Canadian-French
COUNTRY_LATINAMERICA            equ 003                 ; Latin America
COUNTRY_RUSSIA                  equ 007                 ; Russia
COUNTRY_NETHERLANDS             equ 031                 ; Netherlans
COUNTRY_BELGIUM                 equ 032                 ; Belgium
COUNTRY_FRANCE                  equ 033                 ; France
COUNTRY_SPAIN                   equ 034                 ; Spain
COUNTRY_HUNGARY                 equ 036                 ; Hungary
COUNTRY_CROATIA                 equ 038                 ; Croatia
COUNTRY_SERBIA_YUGOSLAVIA       equ 038                 ; Serbia/Yugoslavia
COUNTRY_SLOVENIA                equ 038                 ; Slovenia
COUNTRY_ITALY                   equ 039                 ; Italy
COUNTRY_SWITZERLAND             equ 041                 ; Switzerland
COUNTRY_SLOVAKIA                equ 042                 ; Slovakia
COUNTRY_CZECHREPUBLIC           equ 042                 ; The Czech Republic
COUNTRY_AUSTRIA                 equ 043                 ; Austria
COUNTRY_UNITEDKINGDOM           equ 044                 ; United Kingdom
COUNTRY_DENMARK                 equ 045                 ; Denmark
COUNTRY_SWEDEN                  equ 046                 ; Sweden
COUNTRY_NORWAY                  equ 047                 ; Norway
COUNTRY_POLAND                  equ 048                 ; Poland
COUNTRY_GERMANY                 equ 049                 ; Germany
COUNTRY_BRAZIL                  equ 055                 ; Brazil
COUNTRY_INTERNATIONAL_ENGLISH   equ 061                 ; International English
COUNTRY_PORTUGAL                equ 351                 ; Portugal
COUNTRY_ICELAND                 equ 354                 ; Iceland
COUNTRY_FINLAND                 equ 358                 ; Finland

COUNTRY_JAPAN                   equ 081                 ; Japan
COUNTRY_KOREA                   equ 082                 ; Korea
COUNTRY_CHINA                   equ 086                 ; China
COUNTRY_TAIWAN                  equ 088                 ; Taiwan
COUNTRY_TURKEY                  equ 090                 ; Turkey
COUNTRY_MIDDLEEAST              equ 785                 ; Middle East/ Saudi Arabia
COUNTRY_SAUIARABIA              equ 785                 ; Middle East/ Saudi Arabia
COUNTRY_ISRAEL                  equ 972                 ; Israel

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Code Pages                                                   ;
        ;...............................................................;

CODEPAGE_UNITEDSTATES           equ 437                 ; United States
CODEPAGE_MULTILINGUAL           equ 850                 ; Multilingual
CODEPAGE_SLAVIC                 equ 852                 ; Slavic
CODEPAGE_SLAVIC_II              equ 855                 ; Slavic II
CODEPAGE_TURKEY                 equ 859                 ; Turkey
CODEPAGE_PORTUGAL               equ 860                 ; Portuguese
CODEPAGE_ICELAND                equ 861                 ; Iceland
CODEPAGE_CANADIANFRENCH         equ 863                 ; Canadian-French
CODEPAGE_MIDDLEEAST             equ 864                 ; Arabic
CODEPAGE_NORDIC                 equ 865                 ; Nordic
CODEPAGE_CYRILLIC               equ 866                 ; Cyrillic

CODEPAGE_JAPAN                  equ 932                 ; Japan
CODEPAGE_KOREA                  equ 934                 ; Korea
CODEPAGE_CHINA                  equ 936                 ; China
CODEPAGE_TAIWAN                 equ 938                 ; Taiwan

CODEPAGE_LATIN_I                equ CODEPAGE_MULTILINGUAL
CODEPAGE_LATIN_II               equ CODEPAGE_SLAVIC

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Date/Time                                                    ;
        ;...............................................................;

DATE_USA                        equ 00h                 ; Month/ day/ year
DATE_EUROPE                     equ 01h                 ; Day/ month/ year
DATE_JAPAN                      equ 02h                 ; Year/ month/ day
DATE_OTHER                      equ 03h                 ; (0ther)

DATE_MMDDYY                     equ DATE_USA            ; Month/ day/ year
DATE_DDMMYY                     equ DATE_EUROPE         ; Day/ month/ year
DATE_YYMMDD                     equ DATE_JAPAN          ; Year/ month/ day
DATE_OTHER                      equ 03h                 ; (0ther)

TIME_12HOUR                     equ 00h                 ; 12-hour time
TIME_24HOUR                     equ 01h                 ; 24-hour time

CURRENCY_BEFORE                 equ 00h
CURRENCY_AFTER                  equ 01h

CURRENCY_NOSPACEBETWEEN         equ 00h
CURRENCY_SPACEBETWEEN           equ 02h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Swappable Data Area Styles                                   ;
        ;...............................................................;

DOS3_SDASTYLE                   equ 0
DOS4_SDASTYLE                   equ 1
DOS5_SDASTYLE                   equ 1
DOS6_SDASTYLE                   equ 1

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Define Structure Sizes                                       ;
        ;...............................................................;

sizedevName             equ 8
sizefnName              equ 8
sizefnExtension         equ 3
sizeFILENAME            equ sizefnName + sizefnExtension
sizeShortZFILENAME      equ sizeFILENAME + 1

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Structure Definitions                                        ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Country Info                                                 ;
        ;...............................................................;

        COUNTRYINFO struc

intlDateFormat          dw ?                            ; date format
intlCurrency            db  5 dup(?)                    ; currency symbol (asciz)
intlThousands           db  2 dup(?)                    ; thousands
intlDecimal             db  2 dup(?)                    ; decimal 
intlDateSep             db  2 dup(?)                    ; date
intlTimeSep             db  2 dup(?)                    ; time
intlBitField            db  ?                           ; currency format (before or after)
intlCurrencyPlaces      db  ?                           ; places after decimal point
intlTimeFormat          db  ?                           ; 12-hour or 24-hour format
intlCaseMap             dd  ?                           ; address of case-mapping routine
intlDataSep             db  2 dup(?)                    ; data-list ...

        COUNTRYINFO ends 

intlCurrency_MASK       equ 0001h
intlCurrencyPreceeds    equ 0
intlCurrencyFollows     equ 1

intlSpace_MASK          equ 0002h
intlNoSpaceinAmount     equ 0
intlSpaceinAmount       equ 1

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  File Name                                                    ;
        ;...............................................................;

        FILENAME struc

fnName                  db '????????'
fnExtension             db '???'

        FILENAME ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Directory Entries                                            ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;  See Functions                                                ;
        ;                                                               ;
        ;       _SearchFirstFileFCB           11h                       ;
        ;       _SearchNextFileFCB            12h                       ;
        ;...............................................................;

        DIRENTRY struc

deName                  db '????????'
deExtension             db '???'
deAttributes            db ?
deExtAttributes         db ?

deReserved1             db ?
deReserved2             dw ?
deReserved3             dw ?
deReserved4             dw ?
deStartClusterExt       dw ?                            ; upper 16 bits extended cluster value

deTime                  dw ?                            ; Time Format
                                                        ;   0 - 4 Two second intervals
                                                        ;   5 -10 Minutes (0 - 59)
                                                        ;  11 -15 Hours (0 - 23)

deDate                  dw ?                            ; Date Format
                                                        ;   0 - 4 Day (1 - 31)
                                                        ;   5 - 8 Month (1 - 12)
                                                        ;   9 -15 Year since 1980

deStartCluster          dw ?
deFileSize              dd ?

        DIRENTRY ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Attribute bits
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ATTR_NORMAL             equ 00h
ATTR_READONLY           equ 01h
ATTR_HIDDEN             equ 02h
ATTR_SYSTEM             equ 04h
ATTR_VOLUME             equ 08h
ATTR_DIRECTORY          equ 10h
ATTR_ARCHIVE            equ 20h
ATTR_SETTABLE           equ (ATTR_READONLY + ATTR_HIDDEN + ATTR_SYSTEM + ATTR_ARCHIVE)
ATTR_MASK               equ 1Fh

ATTR_LONGFILENAME       equ 0Fh

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Special Characters
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DIRENTRY_NEVERUSED      equ 00h
SPECIAL_CHAR            equ 05h
DIRENTRY_DELETED        equ 0E5h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Find First/ Find Next                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;  See Functions                                                ;
        ;                                                               ;
        ;       _FindFirstFile           4Eh                            ;
        ;       _FindNextFile            4Fh                            ;
        ;...............................................................;

        FINDENTRY struc

findSrchDrive           db ?
findSrchName            db '????????'                   ; name to search
findSrchExtension       db '???'
findSrchAttributes      db ?
findDirEntry            dw ?                            ; dir entry (;** Not Double !!)
findDirBegCluster       dd ?                            ; dir beg cluster
findCCBPointer          dw ?                            ; ccb pointer

findFileAttribute       db ?
findFileTime            dw ?
findFileDate            dw ?
findFileSize            dd ?
findFileName            db 13 dup (?)                   ; null terminated name

        FINDENTRY ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Long Filename Find First/ Find Next                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;  See Functions                                                ;
        ;                                                               ;
        ;       _FindFirstFile         714Eh                            ;
        ;       _FindNextFile          714Fh                            ;
        ;...............................................................;

        FINDDATA struc

findDataAttributes      dd ?
findDataCreateTime      dq ?                            ; create time (in extended form)
findDataLastAccessTime  dq ?                            ; last accessed time (in extended form)
findDataLastModifTime   dq ?                            ; last modified time (in extended form)
findDataFileSizeHigh    dd ?                            ; file size high 32 bits
findDataFileSizeLow     dd ?                            ; file size low  32 bits
findDataUnused          db 8 dup(?)                     ; unused 
findDataLongFilename    db 260 dup(?)                   ; long filename
findDataShortFilename   db  14 dup(?)                   ; short filename

        FINDDATA ends

finddataTime            equ _low                        ; word
finddataDate            equ _high                       ; word

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Flags
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FINDDATA_EXTENDEDDATEFORMAT equ 0000h                   ; use 64-bit extended date time format
FINDDATA_MSDOSDATEFORMAT    equ 0001h                   ; use MSDOS date time format

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  File Tables                                                  ;
        ;...............................................................;

        FT struc

nextFTPointer           dd ?
numberSFTEntries        dw ?

        FT ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  System File Tables                                           ;
        ;...............................................................;

        SFT struc

sftRefCount             dw ?
sftMode                 dw ?
sftFileAttrib           db ?
sftDevInfo              dw ?                            ; device info
sftDCB                  dd ?                            ; file DCB address or driver address
sftBegCluster           dd ?                            ; start address of file
sftTime                 dw ?                            ; time stamp
sftDate                 dw ?                            ; date stamp
sftFileSize             dd ?                            ; file size
sftFilePosition         dd ?                            ; current offset into file
sftRelCluster           dw ?                            ; relative cluster
sftDirSector            dd ?                            ; absolute address of directory entry
sftDirSectorOffset      db ?                            ; Offset in Dir Sector
sftFileName             db '????????'
sftFileExtension        db '???'
sftShareSftPointer      dd ?                            ; points to other shared file
sftOwnerMachine         dw ?                            ; virtual machine id #
sftOwnerPSP             dw ?                            ; owner process
;sftShareRecordPtr       dw ?                            ; share record pointer
sftCurCluster           dd ?                            ; 0000 if never read/ written
sftIFSDriverPtr         dd ?                            ; IFS Driver pointer  
sftVolumeId             dd ?                            ; RxDOS extended information

        SFT ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Mode
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sftENTRY_ISFCB          equ 8000h                       ; RxDOS specific
sftDENY_NONE            equ 0040h
sftDENY_READ            equ 0030h
sftDENY_WRITE           equ 0020h
sftEXCLUSIVE            equ 0010h
sftNET_FCB              equ 0070h
sftWRITE                equ 0001h
sftREAD                 equ 0000h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  sftDevInfo
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sftShared               equ 8000h
sftDateset              equ 4000h
sftNoInherit            equ 1000h
sftProtected            equ 0100h                       ; protected mode (can't delete)
sftIsDevice             equ 0080h
sftWritten              equ 0040h                       ; valid only if NOT Device
sftDrivemask            equ 003Fh                       ; valid only if NOT Device

; --- all of the following have meaning when IsDevice is SET ---
sftDeviceIsRemote       equ 8000h                       ; device is remote
sftIoctl                equ 4000h                       ; ioctl also supported
sftPipe                 equ 2000h                       ; is pipe
sftNetworkSpooler       equ 0800h                       ; network spooler
sftEof                  equ 0040h                       ; these flags valid only IF IsDevice
sftBinary               equ 0020h                       ; 0 means ASCII
sftSpecial              equ 0010h
sftIsclock              equ 0008h
sftIsnul                equ 0004h
sftIsstdout             equ 0002h
sftIsstdin              equ 0001h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  File Control Blocks                                          ;
        ;...............................................................;

        FCB struc

fcbDrive                db ?
fcbName                 db '????????'
fcbExtension            db '???'
fcbCurrBlockNo          dw ?
fcbRecordSize           dw ?
fcbFileSize             dd ?
fcbDate                 dw ?
fcbTime                 dw ?
fcbSFN                  db ?                            ; handle to sft system
fcbFlags                db ?                            ; modified flags
fcbDHD                  dd ?                            ; device header/DCB
fcbBegClusterNo         dw ?                            ; start of file cluster number
fcbCurrRecNo            db ?
fcbRandomRecNo          dd ?

        FCB ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Extended FCB Header                                          ;
        ;...............................................................;

        ExtendedFCBHdr struc

extSignature            db ?
                        db '?????'
extAttribute            db ?

        ExtendedFCBHdr ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Disk I/O Structure                                           ;
        ;...............................................................;

        DISKIO struc

diskioStartSector       dd ?                            ; sector number
diskioSectors           dw ?                            ; # sectors
diskioBuffer            dd ?                            ; buffer pointer

        DISKIO ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  System Access Control Block                                  ;
        ;...............................................................;

        DISKACCESS struc

diskAcDrive             dw ?                            ;*
diskAcBegCluster        dd ?                            ;* (cluster #)
diskAcFileSize          dd ?                            ;* file size in bytes
diskAcPosition          dd ?                            ;* read request (access position)
diskAcCurCluster        dd ?                            ;* (cluster #)
diskAcCurSector         dd ?                            ;  (LSN  #)
diskAcOffAtBegCluster   dd ?                            ;* (file offset )
diskAcOffAtBegBuffer    dd ?                            ;  (file offset )
diskAcBufferPtr         dd ?                            ;  dynamically assigned
diskAcOptions           dw ?                            ;  optimize options
diskAcBytesToRead       dw ?                            ;  fast read

        DISKACCESS ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Options (options contains ccb_ defines in lower byte)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DISKAC_OPTIMIZEDWRITE             equ 8000h
DISKAC_READBUFFER_ASSIGNED        equ 4000h
DISKAC_READ_MULTIPLESECTORS       equ 2000h
DISKAC_RESULT_READMULTIPLESECTORS equ 1000h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Directory Access Block                                       ;
        ;...............................................................;

        DIRACCESS struc

fileAcDrive             dw ?                            ; which drive file is located
fileAcCluster           dd ?                            ; which cluster file is located
fileAcDirCluster        dd ?                            ; which dir cluster
fileAcDirSector         dd ?                            ; which dir sector
fileAcDirOffset         dw ?                            ; offset in directory sector
fileAcBufferPtr         dd ?                            ; pointer to directory buffer
fileAcDevicePtr         dd ?                            ; if device, device driver address
fileAcNameOffset        dw ?                            ; offset in Expanded Name
fileAcShortName         db   14 dup (?)                 ; short name
fileAcExpandedName      db 1024 dup (?)                 ; fully expanded name

        DIRACCESS ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Flags for file parsing
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FILE_ORDEVICE           equ 0000h                       ; file or device must exist
FILEIS_FCB              equ 0001h                       ; file passed is an FCB
FILE_NODEVICENAME       equ 0002h                       ; path may not contain a device name
FILEHAS_WILDCHARS       equ 0004h                       ; path may contain wild characters
FILEHAS_NOFILENAME      equ 0008h                       ; path may not contain filename
FILECANNOT_BEDEFINED    equ 0010h                       ; filename must not exist
FILECANNOT_BEDIRECTORY  equ 0020h                       ; filename cannot be directory
FILEMAY_EXIST           equ 0040h                       ; file may exist (cluster not -1)
FILTER_ONATTRIBUTES     equ 0080h                       ; LFN, must filter on search attributes

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Std Character I/O Redirection Table                          ;
        ;...............................................................;

        STDREDIREC struc

stdDriverName           db '????????'                   ; driver name
stdIOHandle             dw ?                            ; handle assigned, if any
stdDevInfo              dw ?                            ; device assign bits

        STDREDIREC ends

stdRedirec_Con          equ 0
stdRedirec_Aux          equ 1
stdRedirec_Prn          equ 2

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Drive Parameter Block                                        ;
        ;...............................................................;

        DPB struc

_dpbDrive                         db ?                  ; logical drive
_dpbUnit                          db ?                  ; logical unit
_dpbBytesPerSector                dw ?
_dpbClusterSizeMask               db ?
_dpbClusterSizeShift              db ?
_dpbFirstFAT                      dw ?                  ; (NotUsed:Fat32) 
_dpbNumCopiesFAT                  db ?
_dpbMaxAllocRootDir               dw ?
_dpbFirstDataSector               dw ?                  ; (NotUsed:Fat32) 
_dpbMaxClusterNumber              dw ?                  ; (NotUsed:Fat32)

_dpbSectorsPerFat                 dw ?                  ; (if 0, this is a Fat32 drive)   <--
_dpbFirstDirSector                dw ?                  ; (NotUsed:Fat32)
_dpbptrDeviceDriver               dd ?
_dpbMediaDescriptor               db ?
_dpbAccessFlag                    db ?                  ; -1 if must be rebuilt
_dpbNextDPB                       dd ?
_dpbNextFree                      dw ?                  ; cluster where to search for next free
_dpbFreeCount                     dd ?                  ; number of free clusters remaining

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; FAT32 extended info
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_dpbxFlags                        dw ?                  ; see flags below
_dpbxFSINFOSector                 dw ?                  ; * file system info sector (-1 if none )
_dpbxBackUpBootSector             dw ?                  ; * address of backup boot sector (-1 if none )
_dpbxFirstSector                  dd ?                  ; sector address of first cluster
_dpbxMaxCluster                   dd ?                  ; max clusters in drive plus one
_dpbxSectorsPerFat                dd ?                  ; number of sectors in FAT
_dpbxRootCluster                  dd ?                  ; cluster number of root directory
_dpbxNextFreeCluster              dd ?                  ; most recently allocated cluster
_dpbxFreeClusterCount             dd ?                  ; free clusters on drive

        ; * value must be non-zero and less than the reserved sector count. 

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; RxDOS extended info (non standard usage)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_dpbxReserveSectors               dd ?                  ; Sector of Active FAT
_dpbVolumeId                      dd ?                  ; RxDOS extended information

        DPB ends

sizeDPB                 equ size DPB
sizeEXTDPB              equ size DPB

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; FAT32 Flag Bits ( bits 4-6 and 8-15 are reserved )
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
BPB_ACTIVEFATMASK                 equ 000Fh             ; active FAT
BPB_NOFATMIRROR                   equ 0080h             ; No FAT Mirror
BPB_FREESPACEALTERED              equ 0040h             ; free space requires update

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  BIOS Parameter Block                                         ;
        ;...............................................................;

        BPB struc

_bpbBytesPerSector                dw ?
_bpbSectorsPerCluster             db ?
_bpbResSectors                    dw ?
_bpbNumCopiesFAT                  db ?
_bpbMaxAllocRootDir               dw ?
_bpbMaxSectors                    dw ?                  ; if zero, see huge sectors
_bpbMediaDescriptor               db ?                  ; device media id
_bpbSectorsPerFat                 dw ?                  ; (NotUsed:Fat32) 
_bpbSectorsPerTrack               dw ?
_bpbHeads                         dw ?
_bpbHiddenSectors                 dd ?
_bpbHugeSectors                   dd ?                  ; total num/sectors on big drives

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; FAT32 extended info
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_bpbxBigSectorsPerFat             dd ?                  ; num/sectors per FAT on the FAT32 drive
_bpbxExtendedFlags                dw ?
_bpbxFileSysVersion               dw ?                  ; file system version number (high byte = major version/ low byte = minor version)
_bpbxRootDirStartCluster          dd ?                  ; cluster number of the first cluster in the FAT32 drive's root directory
_bpbxFSINFOSector                 dw ?                  ; if filesys contains a BIGFATBOOTFSINFO structure
_bpbxBackUpBootSector             dw ?
_bpbxFreeClusters                 dd ?                  ; free clusters
_bpbxNextFreeCluster              dd ?                  ; next free cluster
_bpbxReserved                     dd ?

        BPB ends

sizeBPB                 equ size BPB

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  FAT32 Boot File System Structure                             ;
        ;...............................................................;

        BIGFATBOOTFSINFO struc

_bfFSInfoSignature                dd ?                  ; must be 0x61417272
_bfFSInfoFreeClusterCnt           dd ?                  ; free clusters on system
_bfFSInfoNextFreeCluster          dd ?                  ; next free cluster
_bfFSInfoReserved                 dd 3 dup(?)           ; reserved

        BIGFATBOOTFSINFO ENDS

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Extended Free Space                                          ;
        ;...............................................................;

        EXTENDEDFREESPACE struc

_extFreeSize                      dw ?                  ; sizeEXTENDEDFREESPACE
_extFreeLevel                     dw ?                  ; 0
_extFreeSectorsPerCluster         dd ?                  ; num sectors per cluster
_extFreeBytesPerSector            dd ?                  ; num bytes per sector
_extFreeAvailableClusters         dd ?                  ; num available clusters
_extFreeTotalClusters             dd ?                  ; total num clusters for drive
_extFreeAvailablePhysSectors      dd ?                  ; num free physical sectors, w/o compression
_extFreeTotalPhysSectors          dd ?                  ; num total physical sectors, w/o compression
_extFreeAvailableAllocationUnits  dd ?                  ; num free allocation units, w/o compression
_extFreeTotalAllocationUnits      dd ?                  ; num total allocation units, w/o compression
_extFreeReserved                  dd 2 dup (?)

        EXTENDEDFREESPACE ends


IF 0    ; code remains here for comment purposes

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Drive Parameter Block                                        ;
        ;...............................................................;

        DPB struc

_dpbDrive                         db ?                  ; logical drive
_dpbUnit                          db ?                  ; logical unit
_dpbBytesPerSector                dw ?
_dpbClusterSizeMask               db ?
_dpbClusterSizeShift              db ?
_dpbFirstFAT                      dw ?
_dpbNumCopiesFAT                  db ?
_dpbMaxAllocRootDir               dw ?
_dpbFirstDataSector               dw ?
_dpbMaxClusterNumber              dw ?                  ; (NotUsed:Fat32)

_dpbSectorsPerFat                 dw ?                  ; (if 0, this is a Fat32 drive)
_dpbFirstDirSector                dw ?                  ; (NotUsed:Fat32)
_dpbptrDeviceDriver               dd ?
_dpbMediaDescriptor               db ?
_dpbAccessFlag                    db ?                  ; -1 if must be rebuilt
_dpbNextDPB                       dd ?
_dpbNextFree                      dw ?                  ; cluster where to search for next free
_dpbFreeCount                     dd ?                  ; number of free clusters remaining
_dpbVolumeId                      dd ?                  ; RxDOS extended information

        DPB ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  BIOS Parameter Block                                         ;
        ;...............................................................;

        BPB struc

_bpbBytesPerSector                dw ?
_bpbSectorsPerCluster             db ?
_bpbResSectors                    dw ?
_bpbNumCopiesFAT                  db ?
_bpbMaxAllocRootDir               dw ?
_bpbMaxSectors                    dw ?                  ; if zero, see huge sectors
_bpbMediaDescriptor               db ?                  ; device media id
_bpbSectorsPerFat                 dw ?                  ; (NotUsed:Fat32) 
_bpbSectorsPerTrack               dw ?
_bpbHeads                         dw ?
_bpbHiddenSectors                 dd ?
_bpbHugeSectors                   dd ?                  ; total num/sectors on big drives

        BPB ends
ENDIF

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Boot Sector Parameter Block                                  ;
        ;...............................................................;

        BOOTSECTOR struc

_bsJump                           db 3 dup(?)
_bsOemName                        db 8 dup(?)
_bsBytesPerSector                 dw ?                  ; (start of BPB)
_bsSectorsPerCluster              db ?
_bsResSectors                     dw ?                  ; 32 for FAT32, else 1.
_bsNumCopiesFAT                   db ?
_bsMaxAllocRootDir                dw ?
_bsMaxSectors                     dw ?                  ; if zero, see huge sectors
_bsMediaDescriptor                db ?
_bsSectorsPerFat                  dw ?
_bsSectorsPerTrack                dw ?                  ; if zero, Fat32
_bsHeads                          dw ?
_bsHiddenSectors                  dd ?
_bsHugeSectors                    dd ?                  ; (end of BPB)

; ---- FAT16, FAT12 ----------------------------------
_bsDriveNumber                    db ?
                                  db ?
_bsBootSignature                  db ?                  ; 29h if extended boot sector
_bsVolumeId                       dd ?
_bsVolumeLabel                    db 11 dup(?)          ; not same as DOS Volume Id
_bsFileSystemType                 db 8 dup(?)           ; 'FAT12   ', 'FAT16   '

        BOOTSECTOR ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Boot Sector Parameter Block                         (FAT32 ) ;
        ;...............................................................;

        BOOTSECTOR32 struc

_bsxJump                          db 3 dup(?)
_bsxOemName                       db 8 dup(?)
_bsxBytesPerSector                dw ?                  ; (start of BPB)
_bsxSectorsPerCluster             db ?
_bsxResSectors                    dw ?                  ; 32 for FAT32, else 1.
_bsxNumCopiesFAT                  db ?
_bsxMaxAllocRootDir               dw ?
_bsxMaxSectors                    dw ?                  ; if zero, see huge sectors
_bsxMediaDescriptor               db ?
_bsxSectorsPerFat                 dw ?                  ; if 0, FAT32 drive
_bsxSectorsPerTrack               dw ?
_bsxHeads                         dw ?
_bsxHiddenSectors                 dd ?
_bsxHugeSectors                   dd ?                  ; (end of BPB)

; ---- FAT32 -----------------------------------------
_bsxBigSectorsPerFat              dd ?                  ; number of sectors in FAT
_bsxExtendedFlags                 dw ?                  ; extended flags (unknown use)
_bsxFileSysVersion                dw ?                  ; file system version number (high byte = major version/ low byte = minor version)
_bsxRootCluster                   dd ?                  ; cluster number of root directory
_bsxFSINFOSector                  dw ?                  ; file system info sector (-1 if none )
_bsxBackUpBootSector              dw ?                  ; address of backup boot sector (-1 if none )
_bsxReserved                      dd 3 dup(?)

; ---- FAT32 -----------------------------------------
_bsxDriveNumber                   dw ?
_bsxBootSignature                 db ?                  ; 29h if extended boot sector
_bsxVolumeId                      dd ?
_bsxVolumeLabel                   db 11 dup(?)          ; not same as DOS Volume Id
_bsxFileSystemType                db 8 dup(?)           ; 'FAT32   '

        BOOTSECTOR32 ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Partition Table Record                                       ;
        ;...............................................................;

        PARTITION struc

_ptBootable             db ?                            ; 80h = bootable, 00h = nonbootable
_ptBeginHead            db ?                            ; begin head address
_ptBeginSector          db ?                            ; begin sector address
_ptBeginCylinder        db ?                            ; begin cylinder address
_ptFileSystemName       db ?                            ; file system identifier (see below)
_ptEndHead              db ?                            ; end head address
_ptEndSector            db ?                            ; end sector address
_ptEndCylinder          db ?                            ; end cylinder address
_ptStartSector          dd ?                            ; start sector (relative to beg of disk)
_ptSectors              dd ?                            ; number of sectors in partition

        PARTITION ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;  File System ID Codes
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

FILESYSID_UNKNOWN       equ 00h                         ; unknown
FILESYSID_12FAT         equ 01h                         ; 12-bit FAT (max 10 MBytes)
FILESYSID_16FAT         equ 04h                         ; 16-bit FAT (max 32 MBytes)
FILESYSID_EXTENDED      equ 05h                         ; Extended DOS partition
FILESYSID_LARGE16FAT    equ 06h                         ; 16-bit FAT (>= 32 MBytes)
FILESYSID_32FAT         equ 0Bh                         ; 32-bit FAT (max 2047GB)
FILESYSID_32XFAT        equ 0Ch                         ; 32-bit FAT using LBA int 13

FILESYSID_16XFAT        equ 0Eh                         ; 16-bit FAT using LBA int 13 (06h)
FILESYSID_16EXTENDEDX   equ 0Fh                         ; 16-bit FAT using LBA int 13 (05h)
      ; * LBS is logical block addressing for extended int 13 functions

RxDOS_PARTITIONSIGNATURE equ 0AA55h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Parameter Block                                       ;
        ;...............................................................;

        DEVPB struc

_dpSpecialFunc          db ?
_dpDevType              db ?                            ; device type
_dpDevAttr              dw ?                            ; device attributes
_dpCylinders            dw ?                            ; number of cylinders
_dpMediaType            db ?                            ; media type

      ; always followed by a BPB

        DEVPB ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Current Directory Entries                                    ;
        ;...............................................................;

        CDS struc

_cdsActualDirectory     db 67 dup (?)                   ; asciz name
_cdsFlags               dw ?
_cdsPtrToDPB            dd ?
_cdsStartClusterDir     dd ?                            ; 
_cdsNetwParameter       dw ?                            ; padding for network record
_cdsNonSubstOffset      dw ?

                        db ?                            ; compatability byte
_cdsPtrtoIFSDriver      dd ?
                        dw ?                            ; compatability word

        CDS ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Redirection for IFS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_cdsRedirectIFSPtr      equ _cdsStartClusterDir

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Flags
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_CDS_NETWORKEDDRIVE     equ 8000h
_CDS_PHYSICALDRIVE      equ 4000h
_CDS_JOINEDDRIVE        equ 2000h
_CDS_SUBSTDRIVE         equ 1000h
_CDS_NONETLISTING       equ 0080h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Current Directory Entries                                    ;
        ;...............................................................;

        LFNCDS struc

_lfncdsLongDirectory    db 1024 dup (?)                 ; long filename
_lfncdsLength           dw ?                            ; string length
_lfnPtrToCDS            dd ?                            ; pointer to CDS

        LFNCDS ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Memory Management Blocks                                     ;
        ;...............................................................;

        MEMBLOCK struc

_memSignature           db ?                            ; always 4D
_memParent              dw ?                            ; seg address of owner
_memAlloc               dw ?                            ; allocated size
_memReserved            db '???'
_memPgmName             db 8 dup (?)                    ; program name or null

        MEMBLOCK ends

_RxDOS_MEMSIGNATURE     equ 4Dh
_RxDOS_ENDSIGNATURE     equ 5Ah
_RxDOS_PARENT_SIGNATURE equ 0008h                       ; mem parent signature
_RxDOS_FREE_MEMBLOCK    equ 0000h                       ; mem block is free
_RxDOS_HIGHMEMBLOCK     equ 0A000h - 1                  ; start mem block for high mem

_MIN_RxDOS_ALLOC_PARAS  equ 2

_MEM_FIRSTFIT_STRATEGY  equ 0003h                       ; masks for allocation test
_MEM_BESTFIT_STRATEGY   equ 0001h
_MEM_LASTFIT_STRATEGY   equ 0002h

_MEM_FIRSTFIT_LOW       equ 0000h                       ; strategy requests
_MEM_BESTFIT_LOW        equ 0001h
_MEM_LASTFIT_LOW        equ 0002h

_MEM_FIRSTFIT_HIGH      equ 0080h
_MEM_BESTFIT_HIGH       equ 0081h
_MEM_LASTFIT_HIGH       equ 0082h

_MEM_FIRSTFIT_HIGHONLY  equ 0040h
_MEM_BESTFIT_HIGHONLY   equ 0041h
_MEM_LASTFIT_HIGHONLY   equ 0042h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Buffers (Cache) Block                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Compatability note:                                          ;
        ;                                                               ;
        ;  This buffer's definition is slightly different from MSDOS    ;
        ;  but appears to function in exactly the same way.             ;
        ;                                                               ;
        ;...............................................................;

        CCB struc

ccbNext                 dw ?                            ; next cache control block 
ccbPrev                 dw ?                            ; prev cache control block 
ccbDrive                db ?                            ; drive
ccbStatus               db ?                            ; status flags
ccbLBN                  dd ?                            ; block number (sector)
ccbNumCopies            db ?                            ; number of FAT copies (*)
ccbSectorOffsets        dw ?                            ; offset between FAT sectors (*)
ccbDPB                  dd ?                            ; pointer to drive parameter block
ccbCount                dw ?                            ; count if remote
ccbSFTIdent             db ?                            ; system sft Handle (*)
ccbData                 db 512 dup ( ? )                ; data
                                                        ; (*) unused by RxDOS

        CCB ends

ccbChecksum             equ ccbSectorOffsets            ; checksum protection

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Flags
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

ccb_isONHOLD            equ 01h                         ; used internally
ccb_isFAT               equ 02h
ccb_isDIR               equ 04h
ccb_isDATA              equ 08h
ccb_isVALID             equ 20h                         ; contains valid data 
ccb_isDIRTY             equ 40h
ccb_isREMOTE            equ 80h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Program Segment Prefix (PSP)                                 ;
        ;...............................................................;

        PSP struc

pspInt20                dw ?                            ; Int 20 instruction
pspNextParagraph        dw ?                            ; seg address of next paragraph
                        db ?                            ; not used
pspDispatcher           db   5 dup ( ? )                ; long call to MS-DOS
pspTerminateVect        dd ?                            ; Terminate Vector (Int 22h)
pspControlCVect         dd ?                            ; Control-C Vector (Int 23h)
pspCritErrorVect        dd ?                            ; CritError Vector (Int 24h)
pspParentId             dw ?                            ; PSP seg of parent
pspHandleTable          db  20 dup ( ? )                ; Allocated Handle Table
pspEnvironment          dw ?                            ; seg address of environment block
pspUserStack            dd ?                            ; user stack
pspFileHandleCount      dw ?                            ; handles allocated
pspFileHandlePtr        dd ?                            ; pointer to handle table
pspShareChain           dd ?                            ; Share chain pointer
                        db   4 dup ( ? )                ; unused
pspVersion              dw ?                            ; Major, Minor version (VERS)
                        db  14 dup ( ? )                ; unused
pspDosCall              db   3 dup ( ? )                ; int 21/ retf
                        db   9 dup ( ? )                ; unused
pspFCB_1                db  16 dup ( ? )                ; FCB 1
pspFCB_2                db  16 dup ( ? )                ; FCB 2
                        db   4 dup ( ? )
pspCommandTail          db 128 dup ( ? )                ; command tail (also default DTA )

        PSP ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Exe File Header                                              ;
        ;...............................................................;

        EXEHEADER struc

exeSignature            dw ?                            ; .EXE file signature
exeExtraBytes           dw ?                            ; number of bytes in last partial page
exePages                dw ?                            ; number of whole and partial pages
exeRelocItems           dw ?                            ; number of pointers in reloc table
exeHeaderSize           dw ?                            ; size of header, in paragraphs
exeMinAlloc             dw ?                            ; minimum allocation (parag)
exeMaxAlloc             dw ?                            ; maximum allocation (parag)
exeInitSS               dw ?                            ; initial ss value
exeInitSP               dw ?                            ; initial sp value
exeChecksum             dw ?                            ; complemented checksum
exeInitIP               dw ?                            ; initial ip value
exeInitCS               dw ?                            ; initial cs value
exeRelocTable           dw ?                            ; byte offset to reloc table
exeOverlay              dw ?                            ; overlay number
                        dw 16 dup( ? )                  ; reserved (unused)
exeNewExe               dd ?                            ; pointer to new EXE header

        EXEHEADER ends

EXE_SIGNATURE           equ 5A4DH                       ; 'MZ'

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Execution State                                              ;
        ;...............................................................;

        EXECSTATE struc
                        dw ?
execFlags               dw ?
execProgName            dd ?
execPSP                 dw ?
execStartAddr           dd ?
execProgSize            dd ?

        EXECSTATE ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Load and Execute                                             ;
        ;...............................................................;

        EXEC struc

lexecEnvironment         dw ?
lexecCommandTail         dd ?
lexecFCB_1               dd ?
lexecFCB_2               dd ?

        EXEC ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Load Program                                                 ;
        ;...............................................................;

        LOADPROG struc

lprogEnvironment         dw ?
lprogCommandTail         dd ?
lprogFCB_1               dd ?
lprogFCB_2               dd ?
lprogSSSP                dd ?                           ; starting stack address
lprogCSIP                dd ?                           ; starting code address

        LOADPROG ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Load Overlay                                                 ;
        ;...............................................................;

        LOADOVERLAY struc

loverSegLoadAddress      dw ?
loverRelocFactor         dw ?                           ; .EXE files only

        LOADOVERLAY ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Get Buffered Input Line Structure                            ;
        ;...............................................................;

        BUFLINE struc

bufMaxLength            db ?                            ; max bytes
bufActualLength         db ?                            ; actual bytes read
bufData                 db 128 dup(?)                   ; actual bytes (any length)

        BUFLINE ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Line Editor Structure                                        ;
        ;...............................................................;

        LINEEDITOR struc

editCursor              dw ?                            ; cursor offset
editMaxAvail            dw ?                            ; max characters in buffer
editMaxBuffer           dw ?                            ; max characters allowed
editFlags               dw ?                            ; flags
editPhysCursorRow       db ?                            ; beg of edit phys cursor pos
editPhysCursorCol       db ?                            ; beg of edit phys cursor pos
editBufPointer          dd ?                            ; pointer to client buffer
editTemplateCharsAvailable dw ?                         ; characters available

        LINEEDITOR ends

editInsertFlag          equ 8000h                       ; insert mode
editSearchFlag          equ 4000h                       ; search mode
editControlFlag         equ 2000h                       ; next character a control character

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Clock Data                                                   ;
        ;...............................................................;

        CLOCKDATA struc

cl_daysSince1980        dw ?                            ; since Jan 1, 1980
cl_minutes              db ?
cl_hours                db ?
cl_hseconds             db ?
cl_seconds              db ?

cl_day                  db ?
cl_month                db ?
cl_year                 dw ?

        CLOCKDATA ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DOSERROR Structure                                           ;
        ;...............................................................;

        DOSERROR struc

errAX                   dw ?                            ; AX
errBX                   dw ?                            ; BX
errCX                   dw ?                            ; CX
errDX                   dw ?                            ; DX
errSI                   dw ?                            ; SI
errDI                   dw ?                            ; DI
errDS                   dw ?                            ; DS
errES                   dw ?                            ; ES
errReserved             dw ?                            ; Reserved
errUID                  dw ?                            ; user (computer) ID
errPID                  dw ?                            ; program ID (PSP)

        DOSERROR ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DOS Error Messages                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  All error messages are defined here.                         ;
        ;                                                               ;
        ;                                                               ;
        ;...............................................................;

errInvalidFunction      equ 0001h
errFileNotFound         equ 0002h
errPathNotFound         equ 0003h
errIllegalName          equ ( errPathNotFound )

errNoHandlesAvailable   equ 0004h
errAccessDenied         equ 0005h
errInvalidHandle        equ 0006h
errArenaTrashed         equ 0007h
errNotEnoughMemory      equ 0008h
errInvalidBlock         equ 0009h

errInvalidAccess        equ 000Ch
errInvalidDrive         equ 000Fh
errCurrentDirectory     equ 0010h
errNoMoreFiles          equ 0012h
errFileExists           equ 0050h

errFCBSizeTooLarge      equ 0002h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Critical Error Flags                                         ;
        ;...............................................................;

CRITERROR_IGNORE        equ 00
CRITERROR_RETRY         equ 01
CRITERROR_TERMINATE     equ 02
CRITERROR_FAIL          equ 03

CRITERROR_IGNOREALLOWED equ 0008h                       ; ignore allowed bit
CRITERROR_RETRYALLOWED  equ 0010h                       ; retry allowed bit
CRITERROR_FAILALLOWED   equ 0020h                       ; fail allowed bit

CRITERROR_STDRETRIES    equ 03                          ; retry three times.

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Extended Errors Class Codes                                  ;
        ;...............................................................;

ERRCLASS_OUTRES         equ 01h                         ; out of resources
ERRCLASS_TEMPSIT        equ 02h                         ; not an error, temporary situation
ERRCLASS_AUTH           equ 03h                         ; authorization problem
ERRCLASS_INTRN          equ 04h                         ; internal error
ERRCLASS_HRDFAIL        equ 05h                         ; hardware failure
ERRCLASS_SYSFAIL        equ 06h                         ; system failure
ERRCLASS_APPERR         equ 07h                         ; application error (inv param or buff ptr)
ERRCLASS_NOTFND         equ 08h                         ; item not found
ERRCLASS_BADFMT         equ 09h                         ; bad format
ERRCLASS_LOCKED         equ 0Ah                         ; interlocked item or file
ERRCLASS_MEDIA          equ 0Bh                         ; media error
ERRCLASS_ALREADY        equ 0Ch                         ; item already exists
ERRCLASS_UNK            equ 0Dh                         ; unknown

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Extended Errors Suggested Action Codes                       ;
        ;...............................................................;

ERRACT_RETRY            equ 01h                         ; retry immediately
ERRACT_DLYRET           equ 02h                         ; delay and retry
ERRACT_USER             equ 03h                         ; bad user input
ERRACT_ABORT            equ 04h                         ; terminate in orderly manner
ERRACT_PANIC            equ 05h                         ; terminate immediately
ERRACT_IGNORE           equ 06h                         ; ignore error
ERRACT_INTRET           equ 07h                         ; prompt user (chg disk, etc... )

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Extended Errors Location Codes                               ;
        ;...............................................................;

ERRLOC_UNK              equ 01h                         ; unknown
ERRLOC_DISK             equ 02h                         ; random-access device
ERRLOC_NET              equ 03h                         ; network
ERRLOC_SERDEV           equ 04h                         ; serial device
ERRLOC_MEM              equ 05h                         ; memory

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Parameters Block                                      ;
        ;...............................................................;

DEVICEPARAMETERS     STRUC

devparmSpecialFcts      db ?                            ; special functions
devparmDeviceType       db ?                            ; device type
devparmDeviceAttribs    dw ?                            ; device attributes
devparmNumCylinders     dw ?                            ; # cylinders (size)
devparmMediaType        db ?                            ; media type (00h all except 360k disk)
devparmBPB              db 25 dup(?)                    ; bpb (first 25 bytes)

DEVICEPARAMETERS     ENDS

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Device Type Codes
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DEVICETYPE_360K         equ 00h
DEVICETYPE_720K         equ 02h
DEVICETYPE_FLOPPY       equ 01h                         ; 1.2 M floppy
DEVICETYPE_8_SD         equ 03h                         ; 8 inch single density
DEVICETYPE_8_DD         equ 04h                         ; 8 inch single density
DEVICETYPE_FIXEDDISK    equ 05h                         ; fixed disk
DEVICETYPE_TAPEDRIVE    equ 06h                         ; tape drive
DEVICETYPE_144FLOPPY    equ 07h                         ; 1.44M floppy
DEVICETYPE_RWOPTICAL    equ 08h                         ; read/ write optical disk
DEVICETYPE_288FLOPPY    equ 09h                         ; 2.88M floppy

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  BIOS Parameters                                              ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  These definitions are part of the common BIOS access area    ;
        ;  at seg 40:xxxx                                               ;
        ;                                                               ;
        ;...............................................................;

_BIOS_Memory            equ 0013h
_BIOS_KeyboardFlags     equ 0017h
_BIOS_BreakFlag         equ 0071h
_BIOS_NumFixedDrives    equ 0075h

_BIOS_KB_NumLock        equ 20h                         ; used to set/ alter numlock in init
_BIOS_BREAK_STATE       equ 80h                         ; used to detect Break state

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  SYSINIT Parameters                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  These parameters are passed between rxdosbio.com and rxdos   ;
        ;  at startup.                                                  ;
        ;                                                               ;
        ;...............................................................;

        SYSINIT struc

initBootDrive           db ?                            ; unit code
initTotalDrives         db ?                            ; detected by IO.SYS
initLowMemSegment       dw ?                            ; low memory segment
initMemParagraphs       dw ?                            ; memory size
initDeviceChain         dd ?                            ; start of device chain

initRelocHighBegAddress dd ?
initRelocHighSize       dw ?                            ; bytes to relocate
initRelocHighNotify     dw ?                            ; call back function address

initRelocLowBegAddress  dd ?                            ; only used if IO.SYS reloc to HMA
initRelocLowSize        dw ?                            ; bytes to relocate
initRelocLowNotify      dw ?                            ; call back function address

        SYSINIT ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Disk Parameter Block                                         ;
        ;...............................................................;

        DISKPARAM struc

_dptControlTimers       dw ?                            ; see below for definition
_dptMotorOffDelay       db ?                            ; clock ticks
_dptBytesPerSector      db ?                            ; 00 = 128, 01 = 256, ...
_dptSectorsPerTrack     db ?                            ; 
_dptGapLength           db ?                            ; gap between sectors
                                                        ;  2Ah = 5.25"
                                                        ;  1Bh = 3.5"
_dptDataLength          db ?                            ;
_dptFormatGapLength     db ?                            ; gap length when formatting
_dptFormatFillerByte    db ?                            ; default F6h.
_dptHeadSettleTime      db ?                            ; in milliseconds.
_dptMotorStartTime      db ?                            ; in 1/8 seconds.

        DISKPARAM ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Control Timers
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DPT_STEPRATEMASK        equ 0F000h                      ; bits 15-12
DPT_HEADUNLOADTIME      equ 00F00h                      ; bits 11-08 (0fh = 240 ms)

DPT_HEADLOADTIME        equ 00FEh                       ; bits 07-01 (01h = 4 ms)
DPT_NONDMA_MODE         equ 0001h                       ; bit 0 (always 0)

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Drivers Data Structures                               ;
        ;...............................................................;

DEVICEINIT              equ 00h
MEDIAREQUEST            equ 01h
BUILDBPB                equ 02h
IOCTLREAD               equ 03h
DEVICEREAD              equ 04h
NONDESTRREAD            equ 05h
INPUTSTATUS             equ 06h
INPUTFLUSH              equ 07h
DEVICEWRITE             equ 08h
DEVICEWRITEVERIFY       equ 09h
OUTPUTSTATUS            equ 0ah
OUTPUTFLUSH             equ 0bh
IOCTLWRITE              equ 0ch
OPENDEVICE              equ 0dh
CLOSEDEVICE             equ 0eh
REMOVABLEMEDIA          equ 0fh
OUTPUTTILLBUSY          equ 10h
GENERICIOCTL            equ 13h
GETLOGICALDEVICE        equ 17h
SETLOGICALDEVICE        equ 18h
IOCTLQUERY              equ 19h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Internal Device Service Table                                ;
        ;...............................................................;

        DEVSERVICETABLE  struc

devsrvEntries           db ?
devsrvBranches          dw ?

        DEVSERVICETABLE  ends


        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  General Request Header Definition                            ;
        ;...............................................................;

        DEVReqHeader struc

rhLength                db ?
rhUnit                  db ?
rhFunction              db ?
rhStatus                dw ?
rhReserved              db 8 dup ( ? )

; extended definition
rhMedia                 db ?                            ; Media id

        DEVReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Init Request Header Definition                               ;
        ;...............................................................;

        INITReqHeader struc

irLength                db ?
irUnit                  db ?
irFunction              db ?
irStatus                dw ?
irReserved              db 8 dup ( ? )

irUnits                 db ?                            ; number of units
irEndAddress            dd ?                            ;  input: end available driver mem
                                                        ; OUTPUT: end address resident memory
irParamAddress          dd ?                            ;  input: config.sys device= line
                                                        ; OUTPUT: BPB pointer array
irDriveNumber           db ?                            ;  input: first drive number
irMessageFlag           dw ?                            ; OUTPUT: error-message flag

        INITReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Media Request Header Definition                              ;
        ;...............................................................;

        MEDIAReqHeader struc

mrLength                db ?
mrUnit                  db ?
mrFunction              db ?
mrStatus                dw ?
mrReserved              db 8 dup ( ? )

mrMediaID               db ?                            ;
mrReturn                db ?                            ; Return value
mrVolumeID              dd ?                            ; volume identifier

        MEDIAReqHeader ends

MEDIA_HASCHANGED        equ -1
MEDIA_UNCHANGED         equ  1
MEDIA_UNKNOWN           equ  0

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DPB Request Header Definition                                ;
        ;...............................................................;

        BUILDBPBReqHeader struc

bbrLength               db ?
bbrUnit                 db ?
bbrFunction             db ?
bbrStatus               dw ?
bbrReserved             db 8 dup ( ? )

bbrMediaID              db ?                            ;
bbrFATSector            dd ?                            ; buffer with first FAT sector
bbrBPBAddress           dd ?                            ; BPB address

        BUILDBPBReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Read/ Write Request Header Definition                        ;
        ;...............................................................;

        READReqHeader struc

rwrLength               db ?
rwrUnit                 db ?
rwrFunction             db ?
rwrStatus               dw ?
rwrReserved             db 8 dup ( ? )

rwrMediaID              db ?                            ;
rwrBuffer               dd ?                            ;
rwrBytesReq             dw ?                            ;
rwrStartSec             dw ?                            ; 
rwrVolumeID             dd ?                            ; volume identifier
rwrHugeStartSec         dd ?                            ; 32 bit sector

        READReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  NonDestructive LookAhead Read Definition                     ;
        ;...............................................................;

        NONDESTREADReqHeader struc

ndrLength               db ?
ndrUnit                 db ?
ndrFunction             db ?
ndrStatus               dw ?
ndrReserved             db 8 dup ( ? )

ndrCharRead             db ?                            ; character available

        NONDESTREADReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Definition Header                                     ;
        ;...............................................................;

        DEVICEHEADER struc

devLink                 dd ?
devAttributes           dw ?
devStrategy             dw ?
devInterrupt            dw ?
devName                 db '????????'                   ; character devices

; extended definition ( non-standard )
devTablePtr             dw ?
devLogicalUnit          dw ?

        DEVICEHEADER ends

devUnits                equ devName                     ; block devices

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Definition Flags                                      ;
        ;...............................................................;

DEV_STDINPUT            equ 0001h
DEV_STDOUTPUT           equ 0002h
DEV_NULL                equ 0004h
DEV_CLOCK               equ 0008h

DEV_FASTCHARIO          equ 0010h                       ; supports int 29 fast i/o
DEV_LOGICALMAPPING      equ 0040h                       ; supports logical dev mapping
DEV_IOCTL               equ 0080h                       ; supports IOCTL

DEV_REMOVABLEMEDIA      equ 0800h                       ; supports removable media calls

DEV_OUTPUTTILLBUSY      equ 2000h                       ; supports output till busy
DEV_IOCTL_RW            equ 4000h                       ; supports IOCTL read/write
DEV_CHAR                equ 8000h                       ; character mode device

DEV_BLOCKEXTNADDRESS    equ 0002h                       ; block device support 32 bit extended address
DEV_REQUIRESFATSECTOR   equ 2000h                       ; requires FAT sector address

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Errors And Status                                     ;
        ;...............................................................;

OP_ERROR                equ 8000h
OP_NODATA               equ 0300h
OP_BUSY                 equ 0200h
OP_DONE                 equ 0100h
OP_EXITERROR            equ 8100h

devErrWriteProtectViol  equ  0
devErrUnknownUnit       equ  1
devErrDeviceNotReady    equ  2
devErrUnknownCommand    equ  3
devErrCRCerr            equ  4
devErrBadDriveReq       equ  5
devErrSeekError         equ  6
devErrUnknownMedia      equ  7
devErrSectorNotFound    equ  8
devErrPrinterOutPaper   equ  9
devErrWriteFault        equ 10
devErrReadFault         equ 11
devErrGeneralFailure    equ 12
devErrSharingViolation  equ 13
devErrLockViolation     equ 14
devErrInvalidDiskChange equ 15

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Block Device Info                                            ;
        ;...............................................................;

                DISKBLOCK struc

_dskNextPointer                 dd ?                    ; pointer to next
_dskPhysDriveNumber             db ?                    ; 
_dskDOSLogicalDiskUnit          db ?                    ; 
_dskBPB                         db sizeBPB dup(?)       ; 
_dskFATSystemType               db ?                    ; FAT32 disk type (non-std usage)
_dskDevOpenCount                dw ?                    ; 
_dskDeviceType                  db ?                    ; -1 means DPB not init
_dskStatusFlag                  dw ?                    ; disk change detected status
_dskCylinders                   dw ?                    ; 25
_dskDefaultBPB                  db sizeBPB dup(?)       ; 27 (not used)

_dskPartitionBeginHead          db ?                    ; begin head address
_dskPartitionBeginSector        db ?                    ; begin sector address
_dskPartitionBeginCylinder      db ?                    ; begin cylinder address
_dskPartitionEndHead            db ?                    ; end head address
_dskPartitionEndSector          db ?                    ; end sector address
_dskPartitionEndCylinder        db ?                    ; end cylinder address

_dskCylinderAtLastOp            db ?                    ; 46
_dskClockAtLastOp               dd ?                    ; 47
_dskVolumeName                  db (sizeFILENAME + 1) dup(?)
_dskSerialNumber                dd ?                    ; 57
_dskFATSystemID                 db 8 dup(?)             ; 5B  'FAT32', 'FAT16', 'FAT12'

_dskExtHiddenSectors            dd ?                    ; extended hidden sectors
_dskExtReadWrite                db ?                    ; extended read/write supported
_dskExtReadFct                  dw ?                    ; extended read function
_dskExtWriteFct                 dw ?                    ; extended write function

                DISKBLOCK ends

sizeDISKBLOCK                   equ size DISKBLOCK

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;  Type Codes
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

DSKFILESYSTYPE_12Bits           equ 00h
DSKFILESYSTYPE_16Bits           equ 40h
DSKFILESYSTYPE_Invalid          equ 80h
DSKFILESYSTYPE_IsValid          equ 40h                 ; only bits 7, 6 are assignable

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  BIOS Disk Services Error Codes                               ;
        ;...............................................................;

dskErrNoError           equ  0
dskErrInvalidParameter  equ  1
dskErrAddrMarkNotFound  equ  2
dskErrWriteProtected    equ  3
dskErrSectorNotFound    equ  4
dskErrResetFailed       equ  5
dskErrDisketteRemoved   equ  6
dskErrBadParameterTable equ  7
dskErrDMAOverrun        equ  8
dskErrCross64kBoundary  equ  9
dskErrBadSector         equ 10
dskErrBadCylinder       equ 11
dskErrMediaTypeNotFound equ 12
dskErrInvalidNumSectors equ 13
dskErrControlAddrMark   equ 14
dskErrDMAArbOutOfRange  equ 15
dskErrCRCerror          equ 16
dskErrECCCorrectedErr   equ 17
dskErrControllerFailed  equ 20h
dskErrSeekFailed        equ 40h
dskErrDriveTimeOut      equ 80h
dskErrDriveNotReady     equ 0AAh
dskErrUndefinedError    equ 0BBh
dskErrWriteFault        equ 0CCh
dskErrStatusOpFailed    equ 0DDh

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Con Definitions                                              ;
        ;...............................................................;

BIOS_ConRead            equ 00h
BIOS_ConStatus          equ 01h
BIOS_ConReadFlags       equ 02h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Comm Definitions                                             ;
        ;...............................................................;

BIOS_ComInit            equ 00h                         ; returns line status/ modem status
BIOS_ComWrite           equ 01h                         ; returns line status/ modem status
BIOS_ComRead            equ 02h                         ; returns line status/ modem status
BIOS_ComStatus          equ 03h                         ; returns line status/ modem status

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Comm Line Status Register
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
CommLS_TimeOut          equ 8000h
CommLS_ShiftRegEmpty    equ 4000h
CommLS_HoldRegEmpty     equ 2000h
CommLS_BreakDetect      equ 1000h

CommLS_FE               equ 0800h
CommLS_PE               equ 0400h
CommLS_OE               equ 0200h
CommLS_DataAvail        equ 0100h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Comm Modem Status Register
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
CommMS_RLSD             equ 0080h
CommMS_RING             equ 0040h
CommMS_DSR              equ 0020h
CommMS_CTS              equ 0010h

CommMS_ChgRLSD          equ 0008h
CommMS_ChgRING          equ 0004h
CommMS_ChgDSR           equ 0002h
CommMS_ChgCTS           equ 0001h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Prn Definitions                                              ;
        ;...............................................................;

BIOS_PrnWrite           equ 00h                         ; returns status
BIOS_PrnInit            equ 01h
BIOS_PrnStatus          equ 02h

Prn_RetryCount          equ 03

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Print Status
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Prn_NotBusy             equ 8000h
Prn_Ack                 equ 4000h
Prn_OutOfPaper          equ 2000h
Prn_Selected            equ 1000h

Prn_IOError             equ 0800h
Prn_TimeOut             equ 0100h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Define Structure Sizes                                       ;
        ;...............................................................;

sizeCCB                 equ size CCB
sizeCCBData             equ 512
sizeDIRENTRY            equ size DIRENTRY
maskDIRINDEX            equ (sizeCCBData / sizeDIRENTRY) - 1

sizeFT                  equ size FT
sizeSFT                 equ size SFT
sizeFCB                 equ size FCB
sizeExtendedFCBHdr      equ size ExtendedFCBHdr
sizeCLOCKDATA           equ size CLOCKDATA
sizeDOSERROR            equ size DOSERROR

sizeCDS                 equ size CDS
sizeLFNCDS              equ size LFNCDS
sizeBOOTSECTOR32        equ size BOOTSECTOR32
sizeBIGFATBOOTFSINFO    equ size BIGFATBOOTFSINFO
sizeEXTENDEDFREESPACE   equ size EXTENDEDFREESPACE

sizeVolumeID            equ size _dpbVolumeId
sizeDISKACCESS          equ size DISKACCESS
sizeDIRACCESS           equ size DIRACCESS
sizeFINDENTRY           equ size FINDENTRY
sizeFINDDATA            equ size FINDDATA
sizeFINDDATA_MIN        equ (size FINDDATA) - 274
sizeLFNPATH             equ 1024
sizeLFN                 equ 260

sizeMEMBLOCK            equ size MEMBLOCK 
sizePSP                 equ size PSP
sizePSPHandleTable      equ 20

sizeSector              equ 512
sizePage                equ 512
sizeParagraph           equ 16
sizeParasPerPage        equ (sizePage/ sizeParagraph )
sizeCOUNTRYINFO         equ size COUNTRYINFO
sizeDISKPARAM           equ size DISKPARAM

sizeVolumeLabel         equ 11
sizePARTITION           equ size PARTITION
sizePARTITIONTABLE      equ (4 * sizePARTITION)

sizeEXPANDNAME          equ 128
sizeCmdLine             equ 128
sizeCmdLineStruct       equ (sizeCmdLine + 3)
sizeLINEEDITOR          equ size LINEEDITOR
sizeStdRedirec          equ size STDREDIREC

sizeEXECSTATE           equ size EXECSTATE
sizeEXEHEADER           equ size EXEHEADER
sizeEXEC                equ size EXEC
sizeLOADPROG            equ size LOADPROG
sizeLOADOVERLAY         equ size LOADOVERLAY
sizeSYSINIT             equ size SYSINIT

        ;  Device Headers

sizeINITReqHeader       equ size INITReqHeader
sizeDEVReqHeader        equ size DEVReqHeader
sizeREADReqHeader       equ size READReqHeader
sizeMEDIAReqHeader      equ size MEDIAReqHeader
sizeBUILDBPBReqHeader   equ size BUILDBPBReqHeader
sizeDEVICEHEADER        equ size DEVICEHEADER
sizeMaxReqHeader        equ sizeREADReqHeader

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Stack Space INCREMENT To Reserve                             ;
        ;...............................................................;

RXDOS_PERCALL_STACKRESERVE  equ ( 4 * 1024)
RXDOS_STACKSIZE             equ ( 3 * RXDOS_PERCALL_STACKRESERVE)

