
;*** deutscher tastaturtreiber fuer MF keyboards ***

;*** resident part

	.286
	.model tiny

	include keybgr.inc

?DRIVER	equ 1			;make a DOS driver

	.code

	assume ds:BIOSSEG

if ?DRIVER

externdef install:near

IODAT struct		;structure for dos device drivers
cmdlen	db ?		;+0 
unit	db ?
cmd 	db ?
status	dw ?		;+3
		db 8 dup (?);+5
media	db ?		;+0Dh
trans	dd ?		;+0Eh
count	dw ?		;+12h
start	dw ?		;+14h
drive	db ?		;+16h
IODAT ends

	dw 0ffffh
	dw 0ffffh
	dw 8000h				;attribute
	dw offset devstrat		;device strategy
diaddr	dw offset devint1	;device interrupt
	db 'KEYBGR#1'			;device name 8 chars (use carefully)

saveptr	dd 0

devstrat proc far
	mov cs:word ptr [saveptr+0],bx
	mov cs:word ptr [saveptr+2],es
	ret
devstrat endp

devint2 proc far
	push ds
	push bx
	lds bx,cs:[saveptr]
	mov [bx.IODAT.status],8103h
	pop bx
	pop ds
	ret
devint2 endp

endif

;--- AltGr keys

altgrkeytab label byte
	db 03h			;2 -> 
	db 04h			;3 -> 
	db 08h			;7 -> {
	db 09h			;8 -> [
	db 0Ah			;9 -> ]
	db 0Bh			;0 -> }
	db 0Ch			; -> \
	db 10h			;Q -> @
	db 1Bh			;+ -> ~
	db 32h			;M -> 
	db 56h			;< -> |
ALTGRTABSIZ equ $ - altgrkeytab
	db ''
	db ''
	db '{'
	db '['
	db ']'
	db '}'
	db '\'
	db '@'
	db '~'
	db ''
	db '|'

;--- numlock keys

numpadkeytab label byte
	db 53h		;',' 
NUMPADTABSIZ equ $ - numpadkeytab
	public PLAB1
PLAB1  db ','

;--- ctrl keys

ctrlkeytab label byte
	db 15h		;ctrl z
	db 2ch		;ctrl y
CTRLTABSIZ equ $ - ctrlkeytab
	db 1Ah
	db 19h

;--- standard keys

stdkeytab label byte
	db 15h			;z
	db 1ah			;
	db 27h			;
	db 28h			;
	db 2ch			;y
	db 03h			;2
	db 04h			;3
	db 07h			;6
	db 08h			;7
	db 09h			;8
	db 0ah			;9
	db 0bh			;0
	db 0ch			;sz
	db 0dh			;apost
	db 1bh			;+
	db 29h			;^
	db 2Bh			;#
	db 33h			;,
	db 34h			;.
	db 35h			;-
	db 56h			;<
STDTABSIZ equ $ - stdkeytab

	db 'z'
	db ''
	db ''
	db ''
	db 'y'
L02B3X label byte				  ;CAPS-LOCK insensitive keys
	db 0ffh
	db 0ffh
	db 0ffh
	db 0ffh
	db 0ffh
	db 0ffh
	db 0ffh
	db ''
	db "'"
	db '+'
	db '^'
	db '#'
	db 0ffh			 ;,
	db 0ffh			 ;.
	db '-'
	db '<'

	db 'Z'
	db ''
	db ''
	db ''
	db 'Y'
	db '"'
	db ''
	db '&'
	db '/'
	db '('
	db ')'
	db '='
	db '?'
	db '`'
	db '*'
	db ''
	db "'"
	db ';'
	db ':'
	db '_'
	db '>'

introu15 proc far

	pushf
	cmp ah,4Fh
	jz @F
	popf
	db 0EAh
orgint15 dd 0
@@:
	popf
	cmp al,0E0h
	jnc @F
	pusha
	mov bp,sp
	push es
	push ds
	push 0040h
	pop ds
	call trans
	pop ds
	pop es
	popa
@@:
	iret
introu15 endp

trans proc near
	mov dx,word ptr [kbdstat1]
	CLD
	push cs
	pop es
	mov bl,al
	mov bh,[kbdflgs]
	and al,7Fh
	MOV CX,ALTGRTABSIZ			;ch=0!
	test bh,08h					;right alt (altgr) pressed?
	jz @F
	test dx,0204h				;any ctrl or alt-left pressed?
	jnz @F
	MOV DI,offset altgrkeytab
	jmp scantabX
@@:
	test dl,08h					;any alt pressed?
	jnz exit
	MOV DI,offset ctrlkeytab
	mov CL,CTRLTABSIZ
	test dl,04h					;any ctrl pressed?
	jnz scantabX
	MOV DI,offset stdkeytab
	MOV cl,STDTABSIZ
	cmp al,53h					;numpad ','?
	jnz scantab
	test bh,2					;extended key (E0)?
	jnz scantab
	test dl,20h					;num lock active?
	jz exit
	mov cl,NUMPADTABSIZ
	mov di,offset numpadkeytab
scantabX:
	mov dl,0					;ignore shift state
scantab:
	push cx
	repnz scasb
	pop cx
	jnz exit
	dec di
	add di,cx
	cmp di,offset L02B3X	;caps lock sensitiv?
	jnb @F
	test dl,40h				;shift lock?
	jz @F
	test dl,3				;shift gedrueckt?
	jnz unorm1
	jmp unorm2
@@:
	test dl,3				;shift gedrueckt?
	jz unorm1
unorm2:
	add di,cx
unorm1:
	mov ah,al
	mov al,es:[di]
	cmp al,0FFh
	jz exit
found:
	test bl,80h
	jnz dontsave
	call savekey
dontsave:
	and byte ptr [bp+8*2+2*2],not 1	;clear carry
exit:
	ret
savekey:
	MOV DI,[bufend]
	MOV SI,DI
	INC DI
	INC DI
	CMP DI,[ebufend]
	JNZ @F
	MOV DI,[ebufsta]
@@:
	CMP DI,[bufsta]
	JZ @F					;no more room in buffer
	MOV [SI],AX
	MOV [bufend],DI
@@:
	retn

trans endp

EndOfInt15 label near

;--------------------------------------------------------------------------

psp 	 dw 0
drvflgs  db 00h 		;commandline parameter

if ?SUPPINT2F

introu2f proc far

	cmp ah,?KEYB_KB
	jnz default
	cmp al,00
	jnz default
	cmp bx,"KB"
	jz iskeybgr
default:
	db 0eah
orgint2f dd 0
iskeybgr:
	mov al,0ffh
	mov bx,cs
	iret

introu2f endp

EndOfInt2F label near
endif

if ?DRIVER

devint1 proc far
	pusha
	push ds
	lds bx,cs:[saveptr]
	mov [bx.IODAT.status],8103h
	cmp [bx.IODAT.cmd],00
	jnz @F
	mov [bx.IODAT.status],0100h
	mov cs:[diaddr], offset devint2
	mov word ptr [bx+0eh],offset EndOfInt15
	mov word ptr [bx+10h],cs
	push es
	call install
	pop es
@@:
	pop ds
	popa
	ret
devint1 endp

endif

 end

