
;*** installation part
;--- sets vector INT 15, AH=4F

?ATCHECK	equ 0

	.286
	.model tiny

	.stack 200h

cr equ 13
lf equ 10

	include keybgr.inc

?TRACE	= 0

;externdef	_PARAS_:abs
_PARAS_	equ 10h

	.code

install proc

	push ds
	mov ax,3515h
	int 21h
	mov word ptr cs:orgint15+0,bx
	mov word ptr cs:orgint15+2,es
	push cs
	pop ds
	mov dx,offset introu15
	mov ax,2515h
	int 21h
	pop ds
	ret

install endp

start:
	mov ax,cs
	mov ds,ax
	assume ds:DGROUP

main proc c

local	installed:byte
local	deinst:byte
local	inst2f:byte
local	highmem:byte
local	prglen:word
local	diff:word
local	orgstrat:word
local	orgstrat2:word

	mov psp,es
if ?TRACE
	@stroutc "keybgr psp at "
	@wordout es
	@cr_out
endif
	xor ax,ax
	mov installed,al
	mov deinst,al
	mov byte ptr highmem,01
	mov byte ptr inst2f,01
	mov ax,cs
	sub ax,cs:psp
	mov diff,ax
if ?SUPPINT2F
	MOV ah,?KEYB_KB		;pruefen ob bereits installiert
	mov al,00
	mov bx,"KB"
	INT 2Fh
	cmp al,0FFh
	jnz @F
	mov ds,bx 			;in BX datensegment
	mov byte ptr [installed],1
@@:
endif
;----------------------- parameterzeile auswerten

	MOV CL,DS:[drvflgs]
	mov es,cs:[psp]		;use CS prefix here!
	MOV SI,0081h
	.while (1)
		MOV AX,ES:[SI]		;bits 4 und 0 sind belegt (MF-keyboard + amerikanisch)
		inc si
		.break .if (al == cr)
		.continue .if (al != '/')
		or AH,020h
		.if (ah == 'c')
			mov byte ptr highmem,0
if ?SUPPINT2F
		.elseif (ah == 'u')
			mov dx,offset errstr6
			cmp installed,1
			jnz msg_and_exit
			call deinstall
			mov dx,offset errstr4
			and ax,ax
			jnz msg_and_exit
			mov dx,offset errstr5
			jmp msg_and_exit
		.elseif (ah == 'f')
			mov byte ptr inst2f,00
endif
		.elseif (ah == 'k')
			externdef PLAB1:near
			mov byte ptr ds:[PLAB1],'.'
		.else
			jmp helpstr
		.endif
	.endw
	mov ds:[drvflgs],cl
if ?SUPPINT2F        
	cmp byte ptr installed,0
	jz doinstall
	mov dx,offset errstr2
	jmp msg_and_exit
else
	jmp doinstall
endif
helpstr:
	mov dx,offset errstr3
msg_and_exit:
	push cs
	pop ds
	mov ah,09h
	int 21h
	mov ax,4c00h
	int 21h
doinstall:							;installieren
if ?ATCHECK
	MOV AX,0F000h
	MOV ES,AX
	MOV AL,ES:[0FFFEh]
	CMP AL,0FCh					;muss AT sein
	JZ isat
	push cs
	pop ds
	mov dx,offset errstr1
	mov ah,09
	int 21h
	mov ax,4c01h
	int 21h
isat:
endif
	call install
if ?SUPPINT2F
	test byte ptr inst2f,01
	jz noint2f
	push ds
	mov ax,352fh
	int 21h
	mov word ptr cs:orgint2f+0,bx
	mov word ptr cs:orgint2f+2,es
	push cs
	pop ds
	mov dx,offset introu2f
	mov ax,252fh
	int 21h
	pop ds
noint2f:
endif
	MOV ES,cs:[psp]
	mov cx,ES:[002Ch]
	jcxz @F
	mov es,cx
	MOV AX,4900h				;environment freigeben
	int 21h
@@: 							;files schliessen
	mov cx,5
	mov bx,0000
@@:
	mov ah,3Eh
	int 21h
	inc bx
	loop @B
if ?SUPPINT2F        
								;residente programmgroesse errechnen
	mov dx,offset EndofInt2F
	test byte ptr inst2f,01
	jnz @F
endif
	mov dx,offset EndofInt15
@@:
	mov al,dl
	shr dx,4
	add dx,_PARAS_
	and al,0fh
	jz @F
	inc dx
@@:
	test byte ptr highmem,1		;/U?
	jz goresident

	sub dx,_PARAS_
	mov prglen,dx
	mov ax,5802h				;Get UMB Link Status
	int 21h
	xor ah,ah
	mov orgstrat,ax
	mov ax,5803h				;Set UMB Link Status
	mov bx,0001h				;UMB beruecksichtigen
	int 21h
	mov ax,5800h				;Get Allocation Strategie
	int 21h
	mov orgstrat2,ax
	mov ax,5801h				;Set Allocation Strategie
	mov bx,0081h				;best fit (first high, then low)
	int 21h
	mov bx,prglen
	mov ax,4800h
	int 21h
	jc allocerr
	push ax
	mov ax,5801h				;Set Alloc strat
	mov bx,orgstrat2			;zuruecksetzen
	int 21h
	mov ax,5803h				;Set UMB Link Status
	mov bx,orgstrat				;zuruecksetzen
	int 21h
	pop ax
	push ax
	dec ax
	mov es,ax
	mov ax,0008
	mov es:[0001],ax			;psp im MCB setzen
	mov word ptr es:[0008],"CS"
	mov ax,cs
	mov ds,ax
	cli
	pop es
	mov word ptr cs:[psp],es

	mov si,0000h
	mov di,0000h
	mov cx,prglen
	shl cx,3
	rep movsw

	push es
	pop ds

	mov dx,offset introu15
	mov ax,2515h
	push ds
	int 21h
	pop ds
@@:
if ?SUPPINT2F
	test byte ptr inst2f,01
	jz @F
	mov dx,offset introu2f
	mov ax,252fh
	int 21h
@@:
endif
	sti
	mov ax,4c00h
	int 21h
allocerr:
	mov dx,prglen
goresident:
	MOV AX,3100h				;resident gehen
	int 21h
main endp

;*** deinstallieren ***

deinstall proc c

	assume DS:_TEXT				;DS zeigt auf daten des installierten treibers

	mov ax,3515h
	int 21h
	cmp bx,offset introu15
	jnz exit
	mov ax,es
	mov bx,ds
	cmp ax,bx
	jnz exit
if ?SUPPINT2F
	mov ax,word ptr ds:[orgint2f+0]
	or ax,word ptr ds:[orgint2f+2]
	jz skipcheckint2f
	mov ax,352fh
	int 21h
	cmp bx,offset introu2f
	jnz exit
	mov ax,es
	mov bx,ds
	cmp ax,bx
	jnz exit
	push ds
	lds dx,ds:orgint2f
	mov ax,252fh
	int 21h
	pop ds
skipcheckint2f:
endif
	push ds
	lds dx,ds:orgint15
	mov ax,2515h
	int 21h
	pop ds
	mov es,ds:[psp]
	MOV AX,4900h
	int 21h
	mov ax,1
	ret
exit:
	mov ax,0
	ret
deinstall endp

;*** send a byte (in AL) to the keyboard
if 0
SendByte proc
	MOV AH,03h
	MOV BX,offset LEDflgs
nexttry:
	CLI
	AND BYTE PTR [BX],0CFh		;reset ReSend und Ack
	XOR CX,CX
	PUSH AX
@@:
	IN AL,64h					;warten bis frei
	TEST AL,02h
	LOOPNZ @B
	POP AX
	OUT 60h,AL
	STI
	XOR CX,CX
@@:
	TEST BYTE PTR [BX],10h		;acknowledge?
	JNZ done					;dann ok
	TEST BYTE PTR [BX],20h		;resend?
	LOOPZ @B
	DEC AH
	JNZ nexttry
	OR BYTE PTR [BX],80h		;fehler bei kommunikation
done:
	RET
SendByte endp
endif

if ?ATCHECK
errstr1 db "KEYBGR luft nur auf ATs",cr,lf,'$'
endif
errstr3 db "KEYBGR - deutscher Tastaturtreiber Version 1.03",cr,lf
		db "Public Domain",cr,lf
		db "Aufruf: KEYBGR </C /D /F /K>",cr,lf
		db " /C: Nicht im Upper Memory installieren",cr,lf
if ?SUPPINT2F        
		db " /U: Treiber deinstallieren",cr,lf
		db " /F: keine Installations-Check Routine",cr,lf
endif        
		db " /K: Punkt statt Komma im Ziffernblock",cr,lf
		db '$'
if ?SUPPINT2F        
errstr2 db "KEYBGR ist bereits installiert",cr,lf,'$'
errstr6 db "KEYBGR ist nicht installiert",cr,lf,'$'
errstr4 db "KEYBGR deinstalliert",cr,lf,'$'
errstr5 db "KEYBGR kann nicht deinstalliert werden",cr,lf,'$'
endif

	end start

