
;*** simple terminal prog, communicates with COMx (interrupt) ***

		.386
		.MODEL FLAT, stdcall
		option casemap:none
		option proc:private

cr		equ 13
lf		equ 10

		include keyboard.inc

CStr macro string
local sym
	.const
sym db string,0
	.code
	exitm <offset sym>
	endm

sprintf		equ <wsprintfA>

@flat	equ <ds>

?ANSI		equ 1 				;interpret ANSI escape sequences
?STATUSLINE equ 1				;display status line in first row
?INPTEST	equ 1 				;display key input in last row
?BUFSIZE	equ 100000h			;get 1 MB buffer memory
?SCANOUT	equ 1 				;display keyboard input in upper right corner
?EXITSCAN	equ 2d00h 			;ALT-X terminates app
?DEFCOM		equ 1 				;default COM number
?RTSCTS		equ 0 				;RTS/CTS (hardware) protocol
?XONXOFF	equ 1 				;XON/XOFF (software) protocol
?CHKDSR		equ 0 				;check DSR during send
?SETDTR		equ 1				;set DTR
?SETIER		equ 1				;set IER
?SETLCR		equ 1				;set LCR
?GETI08		equ 0 				;catch int 08 in PM
?GETI09		equ 0				;catch int 09 in PM
?USEINT16	equ 0 				;use int 16
?SENDEOI	equ 1 				;send EOI to COM during initialisation
XON 		equ 11h				;XON is Ctrl-Q
XOFF		equ 13h				;XOFF is Ctrl-S
?VIODIR		equ 0				;???

MODE_SHOWBUFFER	equ 1			;flag bMode: buffer mode on?

;--- some bios vars

NUMROWS		equ <@flat:484h>
NUMCOLS		equ <@flat:44ah>
PAGEOFS		equ <@flat:44eh>
PAGENO		equ <@flat:462h>
CSRPOS		equ <@flat:450h>
CRTPORT		equ <@flat:463h>

@kbdgetstatus macro 			;quick check for pressed key
if ?USEINT16
		mov 	ah,11h
		int 	16h
else
		mov 	ax,@flat:[041Ah]
		cmp 	ax,@flat:[041Ch]
endif
		endm

@kbdgetchar macro
		mov		ah,10h
        int		16h 			;get key
        endm

;--- function prototypes

wsprintfA		proto c :dword, :dword, :VARARG
VioPutCharDir	proto stdcall char:dword
VioSetCurPosDir proto stdcall xpos:dword, ypos:dword
GetComSpeed 	proto stdcall comno:dword
SetComSpeed 	proto stdcall comno:dword,speed:dword

;--- internal protos

PrintStatusLine		proto stdcall pString:dword,dwOffs:dword
PrintComSpeed		proto stdcall
ClearStatusLine		proto
GetStatusLineBuffer proto stdcall

		.DATA

flatseg dd 0

if ?VIODIR
startpage  dd 0
firstline  dd 0
cptr	   dd 0
screensize dd 0
linesize   dd 0
pageend    dd 0
endif

bufsta	dd 00000000
bufend	dd 00000000
bufadr	dd 00000000

dwCom	dd ?DEFCOM		;COM no
g_com 	dd 0			;???
comspeed dd 0
comport	dd 0			;COM port base 3F8/2F8
picport dd 0			;PIC port for this IRQ
intCOvec df 0			;previous COM int vector
if ?GETI08
int08vec df 0
endif
if ?GETI09
int09vec df 0
endif
fStopped db 00
bMode	 db 00			
orgIER	 db 00			;org. value of IER (Interrupt Enable Reg, base+1)
orgLCR	 db 00			;org. value of LCR (Line Control Reg, base + 3)
orgMCR	 db 00			;org. value of MCR (Modem Control Reg, base+4)
omask	 db 00			;PIC mask
escchar  db 00
fEsc	 db 00
intno	 db 00
irqmask  db 00
bHex     db 00
attr1	 db	17h
attr2	 db	17h			;light grey on blue backgr
attr3	 db	17h			;light grey on blue backgr
attr4	 db	30h			;black on cyan
tlptr	 dd 0


		.CONST

;--- translate some function keys

transtab label byte
		db __DEL_MAKE
		db __F1_MAKE
		db __F5_MAKE
		db __F6_MAKE
		db __F7_MAKE
		db __F8_MAKE
		db __F10_MAKE
		db __F12_SCAN
ltranstab equ $ - transtab
		db 7Fh
		db __CTRL_Q
		db __CTRL_G
		db __CTRL_R
		db __CTRL_U
		db __CTRL_W
		db __CTRL_Y
		db __CTRL_A

;--- must match entries in scanprocs

scancodes label byte
		db __CURSOR_DOWN
		db __CURSOR_UP
		db __CURSOR_LEFT
		db __CURSOR_RIGHT
		db __F1_ALT
		db __F2_ALT
		db __F3_ALT
		db __F4_ALT
		db __F5_ALT
		db __F6_ALT
		db __F7_ALT
		db __F8_ALT
		db __F9_ALT
		db __F10_ALT
;;		db __F12_ALT

lscancodes equ $ - offset scancodes

scanprocs label dword
		dd offset _cursordown		;cursors
		dd offset _cursorup
		dd offset _cursorleft
		dd offset _cursorright
		dd offset setcom1			;f1-alt
		dd offset setcom2
		dd offset setcom3
		dd offset setcom4			;f4-alt
		dd offset setto9600			;f5-alt
		dd offset setto19200
		dd offset setto57600
		dd offset setto115200		;f8-alt
		dd offset switchhex			;f9-alt
		dd offset ClrScreen			;f10-alt
;;		dd offset SwitchBufMode

;--- scancodes if buffer mode on

scancodes2 label byte
		db __ESC_MAKE
		db __CURSOR_DOWN
		db __CURSOR_UP
lscancodes2 equ $ - offset scancodes2
scanprocs2 label dword
		dd offset SwitchBufMode
		dd offset _cursordown2
		dd offset _cursorup2

cdseq	db 1bh,'[','B',0
cuseq	db 1bh,'[','A',0
clseq	db 1bh,'[','D',0
crseq	db 1bh,'[','C',0

dHelp	db "COMxDlg v2.7, Public Domain",13,10
		db "usage: COMxDlg [options] [COMno]",13,10
        db "options:",13,10
        db " -?: display this text",13,10
        db "COMno: number of COM for communication, default is 1.",13,10
        db '$'

		.CODE

		include vioout.inc

SetComSpeed proc stdcall uses ebx comnr:dword,speed:dword

local   port:dword

        xor     eax,eax     ;rc=0 ist fehler
        xor     edx,edx
        mov     ecx,speed
        jecxz   exit        ;0 nicht moeglich
        mov     eax,115200
        div     ecx
        and     edx,edx     ;rest uebrig?
        jnz     exit
        mov     ecx,eax     ;teiler -> ecx
        mov     ebx,comnr   ;1-4
        dec     ebx         ;0-3
        cmp     ebx,4
        jnb     exit
        add     ebx,ebx
        mov     ax,@flat:[ebx+400h]
        and     eax,eax
        jz      exit
        mov     port,eax
        mov     edx,port
        add     dl,3
        in      al,dx
        push    eax
        or      al,80h     ;baudratenregister selektieren
        out     dx,al
        mov     edx,port
        mov     al,cl
        out     dx,al
        inc     dl
        mov     al,ch
        out     dx,al
        add     dl,2
        pop     eax
        out     dx,al
        mov     al,1
exit:
        ret
SetComSpeed endp

GetComSpeed proc stdcall uses ebx comnr:dword

local   port:dword

        xor     eax,eax
        mov     ebx,comnr
        dec     ebx
        cmp     ebx,4
        jnb     getcomspeed_err
        add     ebx,ebx
        mov     ax,@flat:[ebx+400h]
        and     eax,eax
        jz      getcomspeed_err
        mov     port,eax

        mov     edx,eax
        add     dl,3
        in      al,dx
        push    eax
        or      al,80h       ;baudratenregister selektieren
        out     dx,al
        mov     edx,port
        in      al,dx
        inc     dl
        mov     ah,al
        in      al,dx
        add     dl,2
        xchg    ah,al
        movzx   ecx,ax
        pop     eax
        out     dx,al
        mov     eax,115200
        xor     edx,edx
        cmp     ecx,1
        jb      getcomspeed_1
        div     ecx
getcomspeed_1:
getcomspeed_err:
        ret
GetComSpeed endp


__checkforwait proc stdcall public 
		ret
        align 4
__checkforwait endp

setintirq proc stdcall reqcom:dword

		mov 	eax,reqcom
		cmp 	eax,1
		jz		com1
		cmp 	eax,2
		jz		com2
		cmp 	eax,3
		jz		com3
		cmp 	eax,4
		jz		com4
		xor 	eax,eax
		ret
        align 4
com1:
		mov 	ecx,0Ch 	   ;int#
		mov 	edx,21h 	   ;port PIC
		mov 	ebx,0EFh	   ;irq mask
		jmp 	exit
com2:
		mov 	ecx,0Bh 	   ;int#
		mov 	edx,21h 	   ;port PIC
		mov 	ebx,0F7h	   ;irq mask
		jmp 	exit
com3:
		mov 	ecx,0Ch 	   ;int#
		mov 	edx,21h 	   ;port PIC
		mov 	ebx,0EFh	   ;irq mask
		jmp 	exit
com4:
		mov 	ecx,0Bh 	   ;int#
		mov 	edx,21h 	   ;port PIC
		mov 	ebx,0F7h	   ;irq mask
exit:
		mov 	g_com,eax
		mov 	irqmask,bl
		mov 	picport,edx
		mov 	intno,cl
		ret
        align 4
setintirq endp

GetVideoBuffer proc stdcall

		mov 	eax,0b8000h
		cmp 	byte ptr [CRTPORT],0D4h
		jz		@F
		mov 	eax,0b0000h
@@:
		movzx	edx,word ptr [PAGEOFS]
		add 	eax,edx
		ret
        align 4
GetVideoBuffer endp

getcursorpos proc
		movzx	eax,byte ptr [PAGENO]
		mov 	ax,[eax+CSRPOS]
		ret
        align 4
getcursorpos endp

setcursorpos proc
		movzx	ecx,byte ptr [PAGENO]
		mov 	[ecx+CSRPOS],ax
		ret
        align 4
setcursorpos endp

ClrScreen proc stdcall
		pushad
		invoke	VioSetCurPosDir,0,0
		mov 	cl,[NUMROWS]
		inc 	cl
		movzx	ecx,cl
		mov 	eax,80*2/4
		mul 	ecx
		mov 	ecx,eax

		call	GetVideoBuffer
		mov 	edi,eax

		mov 	eax,07200720h
		cld
		rep 	stosd
		popad
		ret
        align 4
ClrScreen endp

SwitchBufMode proc stdcall
		test	bMode,MODE_SHOWBUFFER
		jnz		@F
		xor		bMode,MODE_SHOWBUFFER
		invoke	PrintStatusLine, CStr("buffer mode (to return press ESC)"), 1
		ret
@@:
		xor		bMode,MODE_SHOWBUFFER
		invoke	PrintComSpeed
		ret
        align 4
SwitchBufMode endp


if ?GETI08
setint08 proc stdcall
		push	es
		mov 	ax,3508h
		int 	21h
		mov 	dword ptr [int08vec+0],ebx
		mov 	word ptr [int08vec+4],es
		pop 	es
		push	ds
		push	cs
		pop 	ds
		mov 	edx,offset myint08
		mov 	ax,2508h
		int 	21h
		pop 	ds
		ret
        align 4
myint08:
		push	eax
		push	ds
		mov		ds,cs:[flatseg]
		inc 	dword ptr ds:[46Ch]
		mov 	al,20h
		out 	20h,al
		pop		ds
		pop 	eax
		sti
		iretd
        align 4
setint08 endp

resetint08 proc stdcall
		push	ds
		lds 	edx,[int08vec]
		mov 	ax,2508h
		int 	21h
		pop 	ds
		ret
        align 4
resetint08 endp
endif

if ?GETI09

setint09 proc stdcall
		push	es
		mov 	ax,3509h
		int 	21h
		mov 	dword ptr [int09vec+0],ebx
		mov 	word ptr [int09vec+4],es
		pop 	es
		push	ds
		push	cs
		pop 	ds
		mov 	edx,offset myint09
		mov 	ax,2509h
		int 	21h
		pop 	ds
		ret
        align 4
myint09:
		push	eax
		push	edx
		mov 	edx,cs:[picport]
		in		al,dx
		mov 	ah,cs:[irqmask]
		xor 	ah,-1
		or		al,ah
		out 	dx,al
		pop 	edx
		pop 	eax
		pushfd
		call	fword ptr cs:[int09vec]
		push	eax
		push	edx
		mov 	edx,cs:[picport]
		in		al,dx
		and 	ah,cs:[irqmask]
		out 	dx,al
		pop 	edx
		pop 	eax
		iretd
        align 4
setint09 endp

resetint09 proc stdcall
		push	ds
		lds 	edx,[int09vec]
		mov 	ax,2509h
		int 	21h
		pop 	ds
		ret
        align 4
resetint09 endp

endif

if ?VIODIR

initscreenptr proc stdcall
		pushad
		call	GetVideoBuffer
		mov 	esi,eax
		mov 	[startpage],esi 		;address
		mov 	[cptr],esi
		movzx	eax,word ptr [NUMCOLS]
		add 	eax,eax 				;no bytes/line
		add 	esi,eax
		mov 	[firstline],esi
		shr 	eax,2
		mov 	[linesize],eax			;no dwords/line
		movzx	ecx,byte ptr [NUMROWS]
		dec 	ecx 					;dont count lowest line 
		mul 	ecx
		mov 	[screensize],eax		;screen size in dwords (1 zeile less)
		add 	eax,[linesize]
		shl 	eax,2
		add 	eax,[startpage]
		mov 	[pageend],eax			;address
		popad
		ret
        align 4
initscreenptr endp

;--- write a character to the screen

__WriteTTY proc near
		pushad
		mov 	edi,[cptr]
		cmp 	al,lf
		jz		dolf
		cmp 	al,cr
		jz		docr
		cmp 	edi,[pageend]
		jb		@F
		call	scroll
@@:
		stosb
		inc 	edi
fertig:
		mov 	[cptr],edi
		popad
		ret
scroll:
		mov 	edi,[startpage]
		mov 	esi,[firstline]
		mov 	ecx,[screensize]
		rep 	movsd
		push	edi
		push	eax
		mov 	eax,07200720h
		mov 	ecx,[linesize]
		rep 	stosd
		pop 	eax
		pop 	edi
		ret
dolf:
		mov 	eax,[linesize]
		shl 	eax,2				  ;in bytes
		add 	edi,eax
		cmp 	edi,[pageend]
		jb		fertig
		call	scroll
		jmp 	fertig
docr:
		mov 	ecx,[linesize]
		shl 	ecx,2				  ;line size in bytes
		xor 	edx,edx
		mov 	eax,edi
		sub 	eax,[startpage]
		div 	ecx
		sub 	edi,edx
		jmp 	fertig

__WriteTTY endp

VioSetCurPosDir proc stdcall spalte:dword, zeile:dword
		pushad
		mov 	eax,zeile
		mul 	linesize	   ;in dwords
		shl 	eax,2
		mov 	ecx,spalte
		shl 	ecx,1
		add 	eax,ecx
		push	eax
		add 	eax,[startpage]
		mov 	[cptr],eax
							   ;set cursor physical
		pop 	ecx
		mov 	al,0Eh
		mov 	dx,[CRTPORT]
		mov 	ah,cl
		out 	dx,ax
		mov 	al,0Fh
		mov 	ah,ch
		out 	dx,ax
		popad
		ret
        align 4
VioSetCurPosDir endp

endif


GetStatusLineBuffer proc stdcall

		call	GetVideoBuffer
if ?STATUSLINE
		movzx	ecx,byte ptr [NUMCOLS]
		shl 	ecx,1
		sub 	eax,ecx
endif
		ret
        align 4
GetStatusLineBuffer endp

ClearLine proc	stdcall uses edi pLine:ptr word
		movzx	ecx,byte ptr [NUMCOLS]
		mov		edi,pLine
		mov		al,' '
@@:
		stosb
		inc		edi
		loop	@B
		ret
        align 4
ClearLine endp

ClearStatusLine proc

		invoke	GetStatusLineBuffer
		invoke	ClearLine,eax
		ret
        align 4
ClearStatusLine endp

PrintStatusLine proc stdcall uses esi edi pString:dword,dwOffs:dword

		call	GetStatusLineBuffer
		mov 	edi,eax
		mov 	eax,dwOffs
		shl 	eax,1
		add 	edi,eax
		mov 	esi,pString
@@:
		lodsb
		and 	al,al
		jz		@F
		stosb
		inc 	edi
		jmp 	@B
@@:
		ret
        align 4
PrintStatusLine endp

;*** display current com speed on screen status line ***

PrintComSpeed proc stdcall uses ebx

local	szStr[80]:byte

		invoke	ClearStatusLine
		invoke	GetComSpeed, g_com
		push	eax
		lea 	ebx,szStr
		invoke	sprintf, ebx, CStr("COM%u with %u Baud      "), g_com, eax
		invoke	PrintStatusLine, ebx, 1
		pop 	eax
		ret
        align 4
PrintComSpeed endp

;*** display ax in upper right corner ***

if ?SCANOUT
testoutax proc stdcall
		pushad
		push	eax
		call	GetStatusLineBuffer
		lea 	edi,[eax+76*2]
		pop 	eax
		push	eax
		mov 	al,ah
		call	_hexout
		pop 	eax
		call	_hexout
		popad
		ret
_hexout::
		push	 eax
		shr 	 al,4
		call	 _nibout
		pop 	 eax
_nibout::
		and 	al,0FH
		cmp 	al,10
		sbb 	al,69H
		das
		mov 	@flat:[edi],al
		inc 	edi
		inc 	edi
		retn
        align 4
testoutax endp
endif

if ?INPTEST
getbase proc stdcall

		call	GetVideoBuffer
		mov 	edi,eax
		mov 	al,[NUMROWS]			;number of rows - 1
		inc 	al
		movzx	eax,al
		mov 	cl,[NUMCOLS]			;number of columns
		movzx	ecx,cl
		shl 	ecx,1
		mul 	ecx
		add 	edi,eax
		ret
        align 4
getbase endp

SetLineAttr proc stdcall

		movzx	ecx,byte ptr [NUMCOLS]
		rep 	stosw
		ret
        align 4
SetLineAttr endp

inittestline proc stdcall
		pushad
		dec 	byte ptr [NUMROWS]		;decrement # of rows 
		call	getbase					;set video ptr (EDI)
if ?STATUSLINE
		pushad
		call	GetVideoBuffer			;get first row
		mov 	edi,eax
		mov 	al,20h
		mov 	ah,attr2
		call	SetLineAttr
		mov		dword ptr ds:[0b8000h],17411742h
		movzx	ecx,byte ptr [NUMCOLS]	;no columns
		dec 	byte ptr [NUMROWS]		;decrement # of rows
		shl 	ecx,1
		add 	[PAGEOFS],cx			;client part starts at row 2
		popad
endif
		mov 	al,20h
		mov 	ah,attr3
		call	SetLineAttr

		mov		ax,0000
		call	setcsr
;;		@putchr cr

		popad
		ret
inittestline endp

deinittestline proc stdcall
		pushad
if ?STATUSLINE
		movzx	ecx,byte ptr [NUMCOLS]
		shl 	ecx,1
		sub 	[PAGEOFS],cx
		inc 	byte ptr [NUMROWS]
		call	GetVideoBuffer
		mov 	edi,eax
		mov 	ax,0720h
		call	SetLineAttr
endif
		call	getbase					;set video ptr (EDI)
		inc 	byte ptr [NUMROWS]
		mov 	ax,0720h
		call	SetLineAttr


		invoke	VioPutCharDir, eax

		popad
		ret
        align 4
deinittestline endp

testoutinbotline proc stdcall
		pushad
		push	eax
		call	getbase					;set video ptr (EDI)
		mov 	eax,tlptr
		cmp 	al,[NUMCOLS]
		jb		@F
		mov 	al,00
@@:
		mov 	ecx,eax
		inc 	al
		mov 	tlptr,eax
		add 	ecx,ecx
		add 	edi,ecx
		pop 	eax
		mov 	ah,attr4
		mov 	@flat:[edi],ax
		and 	ecx,ecx
		jnz 	@F
		mov 	cl,[NUMCOLS]
		add 	ecx,ecx
		add 	edi,ecx
@@:
		mov		al,attr1
		mov 	@flat:[edi-1],al
		popad
		ret
        align 4
testoutinbotline endp


endif

;*** some key functions from table ***

_cursordown:								 ;CURSOR DOWN
		push	offset cdseq
		jmp 	doseq
_cursorup:									 ;CURSOR UP
		push	offset cuseq
		jmp 	doseq
_cursorleft:								 ;CURSOR LEFT
		push	offset clseq
		jmp 	doseq
_cursorright:								 ;CURSOR RIGHT
		push	offset crseq
doseq:
		xchg	esi,[esp]
		cld
@@:
		lodsb
		and 	al,al
		jz		@F
		call	ComWriteTTY
		jmp 	@B
@@:
		pop 	esi
		ret
setcom1:									 ;ALT-F1
		push	1
		jmp 	setcom_l1
setcom2:									 ;ALT-F2
		push	2
		jmp 	setcom_l1
setcom3:									 ;ALT-F3
		push	3
		jmp 	setcom_l1
setcom4:									 ;ALT-F4
		push	4
setcom_l1:
		call	deinitcom
		pop 	eax
		invoke	setintirq,eax
		call	initcom
		and 	eax,eax
		jnz 	setto_l2
		ret
setto9600:									 ;ALT-F5
		mov 	[comspeed],9600
		jmp 	setto_l1
setto19200: 								 ;ALT-F6
		mov 	[comspeed],19200
		jmp 	setto_l1
setto57600: 								 ;ALT-F7
		mov 	[comspeed],57600
		jmp 	setto_l1
setto115200:								 ;ALT-F8
		mov 	[comspeed],115200
setto_l1:
		invoke	SetComSpeed, g_com, comspeed
setto_l2:
		invoke	PrintComSpeed
		ret
_cursordown2:								 ;CURSOR DOWN in buffer mode
		ret
_cursorup2:									 ;CURSOR UP in buffer mode
		ret
        align 4

if ?ANSI

;*** do ANSI escape interpretation

checkesccodes proc stdcall
		cmp 	ax,"[A"
		jz		cursorup
		cmp 	ax,"[B"
		jz		cursordn
		cmp 	ax,"[C"
		jz		cursorright
		cmp 	ax,"[D"
		jz		cursorleft
		invoke	VioPutCharDir, eax
		ret
cursorup:
		call	getcursorpos
		sub 	ah,1
		jnc 	setcsr
		mov 	ah,[NUMROWS]
		jmp 	setcsr
cursordn:
		call	getcursorpos
		add 	ah,1
		cmp 	ah,[NUMROWS]
		jbe 	setcsr
		mov 	ah,0
		jmp 	setcsr
cursorright:
		call	getcursorpos
		add 	al,1				   ;column - 1
		cmp 	al,[NUMCOLS]
		jb		setcsr
		mov 	al,0
		jmp 	setcsr
cursorleft:
		call	getcursorpos
		sub 	al,1				   ;column - 1
		jnc 	setcsr
		mov 	al,[NUMCOLS]
		dec 	al
		jmp 	setcsr
checkesccodes endp

setcsr proc
		call	setcursorpos
		pushad
		movzx	ecx,ah
		movzx	eax,al
		invoke	VioSetCurPosDir,eax,ecx ;col, row
		popad
		ret
        align 4
setcsr endp

endif  ;?ANSI

;*** init com ***

initcom proc stdcall

local	szStr[80]:byte

		mov 	ebx,g_com
		dec 	ebx
		add 	ebx,ebx
		movzx	eax,word ptr @flat:[ebx+400h]
		and 	eax,eax 					   ;does COM exist?
		jnz 	@F
		lea 	ebx,szStr
		invoke	sprintf, ebx, CStr("COM%u does not exist "), g_com
		invoke	PrintStatusLine, ebx, 1
		xor 	eax,eax 					   ;rc=0
		jmp 	exit
@@:
		mov 	comport,eax

		push	es
		mov 	ah,35h
		mov 	al,[intno]
		int 	21h
		mov 	dword ptr intCOvec+0,ebx
		mov 	dword ptr intCOvec+4,es
		pop 	es

		push	ds
		push	cs
		pop 	ds
		mov 	edx,offset intr0x
		mov 	ah,25h
		int 	21h
		pop 	ds

		mov 	edx,[picport]
		in		al,dx
		mov 	[omask],al
		and 	al,[irqmask]
		out 	dx,al

if ?SENDEOI
		mov 	edx,comport
		in		al,dx
endif

if ?SETDTR
		mov 	edx,comport
		add 	edx,4			 ;set DTR
		in		al,dx
		mov 	[orgMCR],al
		and		al, 0E0h		;reset bits 0-4
		or		al,09h			;set DTR, set OUT2, reset RTS, reset loopback mode
		out 	dx,al
endif
if ?SETIER
		mov		edx,comport		;select register
		add		edx, 3
		in		al, dx
		and		al, 7Fh
		out		dx, al

		mov 	edx,comport		;interrupts if char received
		inc 	edx
		in		al,dx
		mov 	[orgIER],al
		mov 	al,1
		out 	dx,al
endif
if ?SETLCR
		mov 	edx,comport
		add 	edx,3
		in		al,dx
		mov 	[orgLCR],al
		mov		al, 3			;set 8 data bits, 1 stop, no parity
		out		dx, al
endif

		invoke	GetComSpeed, g_com
		.if (eax == 1)
			invoke SetComSpeed, g_com,19200
		.endif

exit:
		ret
        align 4
initcom endp

;*** free com port ***

deinitcom proc stdcall

;		 cli
if ?SETIER
		mov 	edx,comport
		add		edx, 3
		in		al, dx
		and		al,7Fh
		out		dx,al

		mov 	edx,comport
		inc 	edx
		mov 	al,[orgIER]
		out 	dx,al
endif
if 0	;?SETLCR
		mov 	edx,comport
		add 	edx,3
		mov 	al,[orgLCR]
		out 	dx,al
endif
if 0	;?SETDTR
		mov 	edx,comport
		add		edx,4
		mov 	al,[orgMCR]
		out 	dx,al
endif
		mov 	edx,picport
		mov 	al,[omask]
		out 	dx,al

		push	ds
		mov 	al,[intno]
		lds 	edx,[intCOvec]
		mov		ah,25h
		int		21h
		pop 	ds

;		 sti

		ret
        align 4
deinitcom endp

;*** char received (interrupt 0B/0D)
;*** put it in input buffer
;*** send XOFF if buffer full

		align	4

intr0x	proc stdcall
		push	ds
		pushad
		mov 	ds,cs:[flatseg]
		mov 	edx,comport
		inc 	edx
		inc 	edx
		in		al,dx
		test	al,1		   ;interrupt occured?
		jz		@F
		popad
		pop 	ds
		pushfd
		call	fword ptr cs:[intCOvec]	;call previous handler
		push	eax
		push	edx
		mov 	edx,cs:[picport]
		in		al,dx
		and 	al,cs:[irqmask]
		out 	dx,al
		pop 	edx
		pop 	eax
		sti
		iretd
@@:
		dec 	edx
		dec 	edx
		mov 	edi,[bufend]
		add 	edi,[bufadr]
		inc 	dword ptr [bufend]
		and 	dword ptr [bufend],?BUFSIZE-1
		in		al,dx
		mov 	[edi],al
		test	byte ptr @flat:[0418h],08h	;pause active?
		jnz 	@F
		mov 	eax,[bufend]
		cmp 	eax,[bufsta]
		jnz 	intr0x_1
@@:
if ?XONXOFF
		mov 	al,XOFF
		out 	dx,al
endif
if ?RTSCTS
		add 	edx,4
		mov 	al,09h
		out 	dx,al
endif
		mov 	byte ptr [fStopped],1
intr0x_1:
		mov 	al,20h
		out 	20h,al
		popad
		pop 	ds
		sti
		iretd
        align 4
intr0x	endp

;*** write char to COM port ***

ComWriteTTY proc stdcall

local	szStr[80]:byte

		mov 	ah,al
if ?CHKDSR
		mov 	edx,port
		add 	edx,6
		in		al,dx			;DSR - modem ready?
		and 	al,20h
		jz		error2
endif
sm1:
		mov 	edx,comport
		add 	edx,5
		mov 	ecx,0000
@@:
		in		al,dx
		and 	al,40h			;last char already digested?
		jnz 	short @F
		loop	@B
		jmp 	error1
@@:
		mov 	al,ah
		mov 	edx,comport
		out 	dx,al
		and 	al,al
		ret
error1:
		invoke	sprintf, addr szStr, CStr(<"Write error at COM%u">), g_com
		jmp		errout
error2:
		invoke	sprintf, addr szStr, CStr(<"Status 'Not ready' at COM%u">),g_com
		jmp		errout
error3:
		invoke	sprintf, addr szStr, CStr(<"COM%u does not exist">), g_com
errout:
		invoke	PrintStatusLine, addr szStr, 1
		stc
		ret
        align 4
ComWriteTTY endp

;*** transform keyboard control keys (F-keys ...) into ASCII ***
;*** return: NC-> write char to COM ***
;***		  C-> do nothing ***

TranslateKey proc stdcall
		cmp 	al,0E0h
		jz		@F
		cmp 	al,0				  ;is it an ascii key?
		clc
		jnz 	translatekey_ex 	  ;then do nothing
@@:
		mov 	edi,offset transtab
		cld
		mov 	al,ah
		mov 	ecx,ltranstab
		repnz	scasb
		stc
		jnz 	translatekey_ex 	  ;nothing found, ignore key
		dec 	edi
		mov 	al,es:[edi+ltranstab]
		clc
translatekey_ex:
		ret
        align 4
TranslateKey endp

;*** keyboard input ***
;*** 1. check if internal command ***
;***	if yes, execute it  ***
;*** 2. check if key is to be translated ***
;***	if yes, do so	 ***
;*** 3. everything else send to COM ***

dispatchkey proc stdcall uses edi
										;check scan codes only!
if ?SCANOUT
		invoke	testoutax
endif
		cld
		mov 	edi,offset scancodes
		mov 	ecx,lscancodes
		push	eax
		mov 	al,ah
		repnz	scasb
		pop 	eax
		jnz 	@F
		sub 	edi,offset scancodes + 1
		call	[edi*4+offset scanprocs]
		ret
@@:
		call	TranslateKey
		jc		@F
		call	ComWriteTTY
		ret
@@:
		ret
        align 4
dispatchkey endp

switchhex proc stdcall
		xor		[bHex],1
		ret
        align 4
switchhex endp


;*** buffermode: change interpretation of keys

checkkey proc stdcall uses edi
		cld
		mov 	edi,offset scancodes2
		mov 	ecx,lscancodes2
		push	eax
		mov 	al,ah
		repnz	scasb
		pop 	eax
		jnz 	@F
		sub 	edi,offset scancodes2 + 1
		call	[edi*4+offset scanprocs2]
		ret
@@:
		ret
        align 4
checkkey endp

;*** display 1 received char (in eax) ***
;*** interpret ESC and BS	 ***

WriteChar proc stdcall


if ?INPTEST
		call	testoutinbotline
endif
		test [bHex],1
        jz  normalmode
		push eax
        shr eax, 4
		call nibout
        pop eax
        call nibout
        mov al,' '
normalmode:
		test	fEsc,1				   ;is escape sequence active?
		jnz 	excnext
		cmp 	al,1Bh				   ;we interpret ESC
		jz		escout
		cmp 	al,08h				   ;we interpret BS
		jz		bsout
		invoke	VioPutCharDir, eax	   ;everything else display directly
		ret
excnext:
		cmp 	[escchar],0
		jnz 	interpretesc
		mov 	[escchar],al
		ret
escout:
		mov 	[escchar],0
		or		fEsc,1
		ret
interpretesc:
		and 	fEsc,0FEh
		mov 	ah,escchar
		call	checkesccodes
		ret
bsout:
		pushad
		call	getcursorpos
		sub 	al,1				   ;column - 1
		jnc 	@F
		mov 	al,0
		sub 	ah,1
		jnc 	@F
		mov 	ah,0
@@:
		call	setcursorpos
		movzx	ecx,ah
		movzx	eax,al
		invoke	VioSetCurPosDir,eax,ecx ;spalte,zeile
		popad
		ret
        align 4
nibout:
		and al,0Fh
        add al,'0'
        cmp al,'9'
        jbe @F
        add al,7
@@:        
		invoke	VioPutCharDir, eax	   ;everything else display directly
        ret
        align 4
WriteChar endp

;*** test if char received. if yes, display it ***
;*** rc: C=nothing received ***

ScreenWriteTTY proc stdcall

		mov 	ebx,[bufsta]
		cmp 	ebx,[bufend]
		jnz 	Swt1
		test	byte ptr [fStopped],1	 ;did we request a stop?
		jz		Swtex					 ;if no, exit with C
		call	Swt1					 ;else display 1 char
		mov 	byte ptr [fStopped],0
if ?RTSCTS
		mov 	edx,port
		add 	edx,4
		mov 	al,0Bh
		out 	dx,al
endif
if ?XONXOFF								 ;send XON
		mov 	edx,comport
		mov 	al,XON
		out 	dx,al
endif
		mov 	ebx,[bufsta]
Swt1:
		add 	ebx,[bufadr]
		mov 	al,[ebx]
		cli
		inc 	dword ptr [bufsta]
		and 	dword ptr [bufsta],?BUFSIZE-1
		sti
		call	WriteChar
		clc
		ret
Swtex:
		stc
		ret
        align 4
ScreenWriteTTY endp

;*** loop until user presses ALT-X ***

mainloop proc stdcall

mainloop1:
		test	bMode,MODE_SHOWBUFFER
		jnz		@F
		call	ScreenWriteTTY			;write a char if available
@@:
		lahf
		push	eax
		@kbdgetstatus					;key pressed?
		pop 	eax
		jnz 	handle_key
		test	ah,1					;was a char displayed?
		jz		mainloop1
		mov 	ax,1680h				;signal idle state
		int 	2fh
		jmp 	mainloop1				;continue
handle_key:
		@kbdgetchar
		cmp 	ax,?EXITSCAN			;ALT-X ?
		jz		exit					;done
		test	bMode,MODE_SHOWBUFFER
		jnz		@F
		call	dispatchkey 			;send char
		jmp 	mainloop1
@@:
		call	checkkey
		jmp		mainloop1
exit:
		ret
        align 4
mainloop endp

checkmono proc
		mov		dx,[CRTPORT]
		cmp		dl,0b4h			;mono?
		jnz		exit
		add		dl,6
		in		al,dx
		mov		al,10h
		mov		dx,3c0h
		out		dx,al
		inc		dl
		in		al,dx			;read 
		dec		dl
		and		al,0FDh			;set bit 1 to 0: color emulation
		out		dx,al
		mov		al,20h
		out		dx,al
		mov		attr1,70h
		mov		attr2,70h
		mov		attr3,70h
		mov		attr4,7Fh
exit:
		ret
        align 4
checkmono endp

getarguments proc

local	szCmdline[128]:byte

		mov ah,51h
        int 21h
        mov esi,80h
        push ds
        mov ds,ebx
        lodsb
        lea edi,szCmdline
        and al,7Fh
        movzx ecx,al
        rep movsb
        mov al,0
        stosb
        pop ds

		lea esi,szCmdline
		.while (byte ptr [esi])
        	lodsb
            .if (al > ' ')
				.if (al == '-')
                	mov al,'/'
                .endif
				.if (al == '/')
                	.if (byte ptr [esi])
                    	lodsb
                        or al,20h
                        .if (al == '?')
                        	jmp dispusage
                        .endif
                    .endif
            	.elseif (al > '0')
	                .if (al <= '4')
						sub al,'0'
						movzx eax,al
						mov dwCom, eax
                    .else
	                   	jmp dispusage
                    .endif
            	.else
                   	jmp dispusage
                .endif
			.endif
		.endw
        clc
        ret
dispusage:                            
		mov edx, offset dHelp
		mov ah,9
		int 21h
		stc
        ret
getarguments endp

;*** main proc ***

main	proc c	argc:DWORD, argv:ptr ptr byte

local	dwCursorPos:DWORD

;-------------------------------- make a video bios call
		mov     ax,1a00h	
		int     10h

		mov		[flatseg],ds
		invoke	getcursorpos
		mov		dwCursorPos, eax
if ?VIODIR
		call	initscreenptr
endif
		invoke	checkmono

		invoke	getarguments
        jc		mainex
        
		invoke	setintirq, dwCom

		push	?BUFSIZE
        pop		cx
        pop		bx
		mov		ax,0501h
        int		31h
        jc		mainex
        push	bx
        push	cx
        pop		eax
		mov 	[bufadr],eax
		xor 	eax,eax
		mov 	[bufsta],eax
		mov 	[bufend],eax
if ?INPTEST
		call	inittestline
endif
		call	initcom
		and 	eax,eax
		jz		mainex

		invoke	PrintComSpeed
		mov 	[comspeed],eax

if ?GETI08
		call	setint08
endif
if ?GETI09
		call	setint09
endif
		call	mainloop
if ?GETI09
		call	resetint09
endif
if ?GETI08
		call	resetint08
endif
if ?INPTEST
		call	deinittestline
endif
		call	deinitcom
		mov		eax, dwCursorPos
		invoke	setcursorpos
mainex:
		ret
        align 4
main	endp

mainCRTStartup proc C public
		invoke main, 0, 0
        mov ah,4ch
        int 21h
mainCRTStartup endp

		END mainCRTStartup

